/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.autoconfigure;

import com.dap.component.dao.api.DaoClassProvider;
import com.digiwin.app.dao.filter.DWFieldValueFilter;
import com.digiwin.app.dao.filter.DWSQLFilterChain;
import com.digiwin.app.dao.filter.DWSQLInjectionCheckFilter;
import com.digiwin.app.dao.filter.DWSQLManagementFieldFilter;
import com.digiwin.app.dao.filter.DWSQLPreLoadMetadataFilter;
import com.digiwin.app.dao.filter.DWSQLTenantIsolationFilter;
import com.digiwin.app.dao.filter.IDWManagementFieldResolver;
import com.digiwin.app.dao.filter.IDWSQLFilter;
import com.digiwin.app.dao.properties.DWDaoProperties;
import com.digiwin.app.data.DWDataSetInsertOption;
import com.digiwin.app.data.generator.DWSnowFlakeValueGenerator;
import com.digiwin.app.data.generator.IDWFieldValueGenerator;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.core.env.Environment;

@Configuration
@DependsOn(value={"daoUpdateTenantDataSource", "daoRequestContextProvider", "daoUpdateDataSource", "daoModuleNameProvider", "daoSpringContextProvider", "daoConfigProvider", "daoResourceBundleProvider", "daoClassProvider", "dw-spring-context-utils", "dw-dao-properties", "dw-json-config"})
public class DWSQLFilterChainAutoConfiguration {
    @Bean(value={"fixedFieldValueGeneratorSettings"})
    @ConditionalOnProperty(value={"dw.dao.fixed.field.value.generator.enabled"}, havingValue="true", matchIfMissing=false)
    public List<DWDataSetInsertOption.DWFieldValueGeneratorSetting> getDWFieldValueGeneratorSetting() {
        ArrayList<DWDataSetInsertOption.DWFieldValueGeneratorSetting> list = new ArrayList<DWDataSetInsertOption.DWFieldValueGeneratorSetting>();
        list.add(new DWDataSetInsertOption.DWFieldValueGeneratorSetting("${primaryKey}", (IDWFieldValueGenerator)new DWSnowFlakeValueGenerator()));
        return list;
    }

    @Bean(value={"dw-sqlFilterChain"})
    @DependsOn(value={"tenantAutoConfiguration"})
    public DWSQLFilterChain getSQLFilterChain(@Qualifier(value="daoClassProvider") DaoClassProvider daoClassProvider, Environment environment, @Autowired(required=false) List<DWDataSetInsertOption.DWFieldValueGeneratorSetting> settings) throws Exception {
        String preLoad;
        List<IDWSQLFilter> filters = this.getCustomFilters(daoClassProvider);
        if (filters == null) {
            DWSQLManagementFieldFilter filter;
            filters = new ArrayList<IDWSQLFilter>();
            if (DWSQLManagementFieldFilter.isEnabled()) {
                filter = DWSQLFilterChainAutoConfiguration.getDefaultMgmtFieldSQLFilter(daoClassProvider);
                filters.add((IDWSQLFilter)filter);
            }
            filter = new DWSQLTenantIsolationFilter();
            filters.add((IDWSQLFilter)filter);
            DWSQLInjectionCheckFilter dwsqlInjectionCheckFilter = new DWSQLInjectionCheckFilter();
            dwsqlInjectionCheckFilter.setCheckSqlInjection(((Boolean)environment.getProperty("dap.dwdao.query.check-sql-injection", Boolean.class, (Object)true)).booleanValue());
            filters.add((IDWSQLFilter)dwsqlInjectionCheckFilter);
            DWFieldValueFilter dwFieldValueFilter = new DWFieldValueFilter();
            dwFieldValueFilter.setFixedFieldValueGeneratorSettings(settings);
            filters.add((IDWSQLFilter)dwFieldValueFilter);
            IDWSQLFilter dataPermSqlFilter = DWSQLFilterChainAutoConfiguration.getDataPermissionSQLFilter(daoClassProvider);
            if (dataPermSqlFilter != null) {
                filters.add(dataPermSqlFilter);
            }
        }
        if (Boolean.parseBoolean(preLoad = environment.getProperty("dap.dwdao.metadata.pre-load-on-sql-filter", "false"))) {
            filters.add((IDWSQLFilter)new DWSQLPreLoadMetadataFilter());
        }
        return new DWSQLFilterChain(filters);
    }

    private static IDWManagementFieldResolver getResolver(@Qualifier(value="daoClassProvider") DaoClassProvider daoClassProvider) throws Exception {
        String mgmtFieldResolverClazz = DWDaoProperties.getDefaultProperties().getMgmtFieldProperties().getMgmtFieldResolver();
        Class resolverClass = daoClassProvider.loadApplicationLayerClass(mgmtFieldResolverClazz);
        return (IDWManagementFieldResolver)resolverClass.newInstance();
    }

    private static DWSQLManagementFieldFilter getDefaultMgmtFieldSQLFilter(@Qualifier(value="daoClassProvider") DaoClassProvider daoClassProvider) throws Exception {
        IDWManagementFieldResolver resolver = DWSQLFilterChainAutoConfiguration.getResolver(daoClassProvider);
        return new DWSQLManagementFieldFilter(resolver);
    }

    private static IDWSQLFilter getDataPermissionSQLFilter(@Qualifier(value="daoClassProvider") DaoClassProvider daoClassProvider) throws Exception {
        IDWSQLFilter result = null;
        String dataPermSqlFilterClassName = DWDaoProperties.getDefaultProperties().getDaoSqlFilterProperties().getDataPermSqlFilter();
        if (dataPermSqlFilterClassName != null) {
            Class dataPermSqlFilterClass = daoClassProvider.loadApplicationLayerClass(dataPermSqlFilterClassName);
            result = (IDWSQLFilter)dataPermSqlFilterClass.newInstance();
        }
        return result;
    }

    private List<IDWSQLFilter> getCustomFilters(@Qualifier(value="daoClassProvider") DaoClassProvider daoClassProvider) throws Exception {
        ArrayList<DWSQLManagementFieldFilter> customFilters = null;
        String dwsqlFilterChianCustom = DWDaoProperties.getDefaultProperties().getDaoSqlFilterProperties().getDwsqlFilterChianCustom();
        if (dwsqlFilterChianCustom != null && dwsqlFilterChianCustom.toLowerCase().startsWith("true:")) {
            String[] parts;
            customFilters = new ArrayList<DWSQLManagementFieldFilter>();
            String customFiltersString = dwsqlFilterChianCustom.substring("true:".length());
            for (String clazzString : parts = customFiltersString.split(",")) {
                Class clazz = daoClassProvider.loadApplicationLayerClass(clazzString);
                Object instance = clazz == DWSQLManagementFieldFilter.class ? DWSQLFilterChainAutoConfiguration.getDefaultMgmtFieldSQLFilter(daoClassProvider) : (IDWSQLFilter)clazz.newInstance();
                customFilters.add((DWSQLManagementFieldFilter)instance);
            }
        }
        return customFilters;
    }
}

