/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.data;

import com.digiwin.app.data.DWBatchResult;
import com.digiwin.app.data.DWCheckItem;
import com.digiwin.app.data.DWFailedRecord;
import com.digiwin.app.data.DWRecordKeys;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DWBatchResultCollector {
    DWBatchResult batchResult = new DWBatchResult();
    List<DWFailedRecord> records = new ArrayList<DWFailedRecord>();
    Map<String, List<DWCheckItem>> checkItemGroup = new HashMap<String, List<DWCheckItem>>();

    public void markBatchTime() {
        Calendar calendar = Calendar.getInstance();
        String timeIsFormatted = this.formatBatchTime(calendar.getTime());
        this.batchResult.setTime(timeIsFormatted);
    }

    private String formatBatchTime(Date batchTime) {
        SimpleDateFormat batchTimeFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        return batchTimeFormat.format(batchTime);
    }

    public void increaseWarningCount() {
        int warningCount = this.batchResult.getWarningCount();
        this.batchResult.setWarningCount(++warningCount);
    }

    public void increaseFailCount() {
        int failCount = this.batchResult.getFailCount();
        this.batchResult.setFailCount(++failCount);
    }

    public void addFailedRecord(String title, String content, String ... keys) {
        this.createFailRecord(keys);
        this.createCheckItems(title, content, keys);
    }

    public void addFailedRecord(String key, String title, String content) {
        this.createFailRecord(key);
        this.createCheckItems(key, title, content);
    }

    public void addWarningRecord(String title, String content, String ... keys) {
        this.createFailRecord(keys);
        this.createWarningItems(title, content, keys);
    }

    public void addWarningRecord(String key, String title, String content) {
        this.createFailRecord(key);
        this.createWarningItems(key, title, content);
    }

    public void createFailRecord(String ... keys) {
        DWFailedRecord recordInKey = null;
        for (DWFailedRecord record : this.records) {
            if (!record.equals(keys)) continue;
            recordInKey = record;
            break;
        }
        if (recordInKey == null) {
            recordInKey = new DWFailedRecord(keys);
            this.records.add(recordInKey);
        }
    }

    public void createFailRecord(String key) {
        DWFailedRecord recordInKey = null;
        for (DWFailedRecord record : this.records) {
            if (!record.getKey().equals(key)) continue;
            recordInKey = record;
            break;
        }
        if (recordInKey == null) {
            recordInKey = new DWFailedRecord(key);
            this.records.add(recordInKey);
        }
    }

    public void createCheckItems(String title, String content, String ... keys) {
        String targetKey = DWRecordKeys.generateKey(keys);
        this.createCheckItems(targetKey, title, content);
    }

    public void createCheckItems(String key, String title, String content) {
        List<DWCheckItem> checkItems = null;
        checkItems = this.checkItemGroup.containsKey(key) ? this.checkItemGroup.get(key) : new ArrayList<DWCheckItem>();
        checkItems.add(new DWCheckItem(title, content, "base"));
        this.checkItemGroup.put(key, checkItems);
        this.increaseFailCount();
    }

    public void createWarningItems(String title, String content, String ... keys) {
        String targetKey = DWRecordKeys.generateKey(keys);
        this.createWarningItems(targetKey, title, content);
    }

    public void createWarningItems(String key, String title, String content) {
        List<DWCheckItem> checkItems = null;
        checkItems = this.checkItemGroup.containsKey(key) ? this.checkItemGroup.get(key) : new ArrayList<DWCheckItem>();
        checkItems.add(new DWCheckItem(title, content, "warning"));
        this.checkItemGroup.put(key, checkItems);
        this.increaseWarningCount();
    }

    public boolean haveFailRecord(String ... keys) {
        String targetKey = DWRecordKeys.generateKey(keys);
        return this.haveFailRecord(targetKey);
    }

    public boolean haveFailRecord(String key) {
        List<DWCheckItem> checkItems = this.checkItemGroup.get(key);
        List<DWCheckItem> warningItems = this.checkItemGroup.get(key);
        if (checkItems == null && warningItems == null) {
            return false;
        }
        int c = 0;
        if (checkItems != null) {
            c = checkItems.size();
        }
        return c > 0;
    }

    public boolean haveFailRecord() {
        boolean haveFail = false;
        for (List<DWCheckItem> checkItems : this.checkItemGroup.values()) {
            if (!checkItems.isEmpty()) continue;
            haveFail = true;
            break;
        }
        return haveFail;
    }

    public boolean haveNoFailRecord() {
        return !this.haveFailRecord();
    }

    public DWBatchResult getBatchResult() {
        DWBatchResult result = new DWBatchResult();
        result.setFailCount(this.batchResult.getFailCount());
        result.setWarningCount(this.batchResult.getWarningCount());
        result.setTime(this.batchResult.getTime());
        ArrayList<DWFailedRecord> resultRecords = new ArrayList<DWFailedRecord>();
        for (DWFailedRecord record : this.records) {
            String key = record.getKey();
            String[] keys = DWRecordKeys.convertKeys(record.getKeys());
            DWFailedRecord failedRecordresult = new DWFailedRecord(this.checkItemGroup.get(key), keys);
            resultRecords.add(failedRecordresult);
        }
        result.setFailedRecords(resultRecords);
        return result;
    }

    public static DWBatchResult getBatchResult(Object object) throws Exception {
        DWBatchResult result = null;
        if (object != null) {
            Gson gsonParser = new GsonBuilder().serializeNulls().create();
            String objectJson = gsonParser.toJson(object);
            result = (DWBatchResult)gsonParser.fromJson(objectJson, DWBatchResult.class);
        }
        return result;
    }
}

