/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.dao.filter;

import com.digiwin.app.dao.filter.IDWManagementFieldResolver;
import com.digiwin.app.dao.properties.DWDaoProperties;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class DWAbstractManagementFieldResolver
implements IDWManagementFieldResolver {
    private Map<String, String> insertMappings = new LinkedHashMap<String, String>();
    private Map<String, String> updateMappings = new LinkedHashMap<String, String>();

    DWAbstractManagementFieldResolver() {
        String rawInsertMappings = DWDaoProperties.getDefaultProperties().getMgmtFieldProperties().getMgmtFieldInsertMappings();
        String rawUpdateMappings = DWDaoProperties.getDefaultProperties().getMgmtFieldProperties().getMgmtFieldUpdateMappings();
        this.initMappins(rawInsertMappings, this.insertMappings);
        this.initMappins(rawUpdateMappings, this.updateMappings);
    }

    private void initMappins(String mappingsSetting, Map<String, String> targetMappings) {
        if (mappingsSetting != null) {
            String[] parts;
            for (String part : parts = mappingsSetting.split(",")) {
                String mappingKeyForValue;
                String dbFieldName;
                if (part.trim().length() == 0) continue;
                int tempIndex = part.indexOf(":");
                if (tempIndex == -1) {
                    mappingKeyForValue = dbFieldName = part;
                } else {
                    dbFieldName = part.substring(0, tempIndex);
                    mappingKeyForValue = part.substring(tempIndex + 1);
                }
                targetMappings.put(dbFieldName, mappingKeyForValue);
            }
        }
    }

    public String[] getInsertFields() {
        Set<String> keys = this.insertMappings.keySet();
        String[] array = keys.toArray(new String[keys.size()]);
        return array;
    }

    public String[] getUpdateFields() {
        Set<String> keys = this.updateMappings.keySet();
        String[] array = keys.toArray(new String[keys.size()]);
        return array;
    }

    public Object getFieldValue(String fieldName) {
        String mappingKey = this.insertMappings.get(fieldName);
        if (mappingKey == null) {
            mappingKey = this.updateMappings.get(fieldName);
        }
        Object value = this.getFieldValue(fieldName, mappingKey);
        return value;
    }

    protected abstract Object getFieldValue(String var1, String var2);

    public List<Object> getInsertFieldValues() {
        ArrayList<Object> values = new ArrayList<Object>();
        for (String fieldName : this.insertMappings.keySet()) {
            values.add(this.getFieldValue(fieldName));
        }
        return values;
    }

    public List<Object> getUpdateFieldValues() {
        ArrayList<Object> values = new ArrayList<Object>();
        for (String fieldName : this.updateMappings.keySet()) {
            values.add(this.getFieldValue(fieldName));
        }
        return values;
    }

    public Map<String, String> getInsertMappings() {
        return this.insertMappings;
    }

    public void setInsertMappings(Map<String, String> insertMappings) {
        this.insertMappings = insertMappings;
    }

    public Map<String, String> getUpdateMappings() {
        return this.updateMappings;
    }

    public void setUpdateMappings(Map<String, String> updateMappings) {
        this.updateMappings = updateMappings;
    }
}

