/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.metadata.rdbms;

import com.digiwin.app.metadata.DWField;
import com.digiwin.app.metadata.DWValidationAttribute;
import com.digiwin.app.metadata.exceptions.DWValidationFailedException;
import com.digiwin.app.metadata.rdbms.DWRdbmsField;

public class DWRdbmsFieldBaseValidationAttribute
extends DWValidationAttribute {
    protected DWRdbmsFieldBaseValidationAttribute(String name) {
        super(name);
    }

    @Override
    public Object validate(DWField field, Object target) throws DWValidationFailedException {
        if (field instanceof DWRdbmsField) {
            return true;
        }
        DWRdbmsField rdbmsField = (DWRdbmsField)field;
        boolean nullable = rdbmsField.isNullable();
        if (!nullable && target == null) {
            throw new DWValidationFailedException(String.format("['%s'] value is null!", field.getName()));
        }
        int size = rdbmsField.getSize();
        if (target != null && target instanceof String && ((String)target).length() > size) {
            throw new DWValidationFailedException(String.format("['%s'] value too long! size is %s!", field.getName(), size));
        }
        return true;
    }
}

