/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.dao;

import com.digiwin.app.dao.DWDataRowSqlInfo;
import com.digiwin.app.data.DWAutoIncrementOption;
import com.digiwin.app.data.DWDataOptimisticLockingInfo;
import com.digiwin.app.data.DWDataRow;
import com.digiwin.app.data.exceptions.DWDataException;
import com.digiwin.app.metadata.rdbms.DWRdbmsMetadata;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;

public class DWBatchDataRowSqlInfo
extends DWDataRowSqlInfo {
    private List<DWDataRow> batchRows;
    private List<List<Object>> batchRowParameters;
    private List<String> columnNameMappingList;
    private List<DWDataOptimisticLockingInfo> batchRowLockingInfoList;
    private boolean hasLockingInfo = false;

    public DWBatchDataRowSqlInfo(DWRdbmsMetadata metadata, int totalRowCount, DWDataRow row, String sql, List<Object> parameters, List<String> columnNameMappingList, DWDataOptimisticLockingInfo lockingInfo) {
        super(metadata, row, sql, parameters);
        if (totalRowCount <= 0) {
            totalRowCount = 10;
        }
        this.batchRows = new ArrayList<DWDataRow>(totalRowCount);
        this.batchRowParameters = new ArrayList<List<Object>>(totalRowCount);
        this.batchRowLockingInfoList = new ArrayList<DWDataOptimisticLockingInfo>(totalRowCount);
        this.batchRows.add(row);
        this.batchRowParameters.add(parameters);
        this.batchRowLockingInfoList.add(lockingInfo);
        this.columnNameMappingList = columnNameMappingList;
        if (lockingInfo != null) {
            this.hasLockingInfo = true;
        }
    }

    public boolean hasLockingInfo() {
        return this.hasLockingInfo;
    }

    public void addBatch(DWDataRow row, List<Object> parameters, List<String> columnNameMappingList) {
        if (this.batchRowParameters.size() > 0 && this.batchRowParameters.get(0).size() != parameters.size()) {
            throw new DWDataException("Wrong number of parameters: expected " + this.batchRowParameters.get(0).size() + ", was given " + parameters.size());
        }
        if (this.columnNameMappingList.size() == columnNameMappingList.size()) {
            int i = 1;
            Iterator<String> firstRowColumns = this.columnNameMappingList.iterator();
            Iterator<String> otherRowColumns = columnNameMappingList.iterator();
            while (firstRowColumns.hasNext()) {
                String otherRowColumnName;
                String firstRowColumnName = firstRowColumns.next();
                if (!firstRowColumnName.equals(otherRowColumnName = otherRowColumns.next())) {
                    throw new DWDataException("Wrong seq." + i + " of parameters: expected " + firstRowColumnName + ", was given " + otherRowColumnName + " at row " + (this.batchRows.size() + 1));
                }
                ++i;
            }
        }
        this.batchRows.add(row);
        this.batchRowParameters.add(parameters);
    }

    public void addBatch(DWDataRow row, List<Object> parameters, List<String> columnNameMappingList, DWDataOptimisticLockingInfo lockingInfo) {
        this.addBatch(row, parameters, columnNameMappingList);
        this.batchRowLockingInfoList.add(lockingInfo);
    }

    public void setGeneratedKeys(List<Object> generatedKeys) {
        if (this.batchRows.size() == 0) {
            return;
        }
        int index = 0;
        String autoIncrementFieldName = this.getMetadata().getAutoIncrement();
        for (DWDataRow row : this.batchRows) {
            row.set(autoIncrementFieldName, generatedKeys.get(index++));
        }
    }

    public int getRowCount() {
        return this.batchRows.size();
    }

    public DWDataOptimisticLockingInfo getLockingInfo(int rowIndex) {
        return this.batchRowLockingInfoList.get(rowIndex);
    }

    public Object[][] getBatchParameters() {
        Object[][] batchParameters = (Object[][])this.batchRowParameters.stream().map(item -> item.toArray()).toArray(x$0 -> new Object[x$0][]);
        return batchParameters;
    }

    public List<List<Object>> getBatchParametersAsList() {
        return this.batchRowParameters;
    }

    public void persist() {
        ((Stream)this.batchRows.stream().parallel()).forEach(DWDataRow::persist);
    }

    protected Object updateAutoIncrementRefColumnValuesCore(int targetRowRefParameterIndex, DWDataRow sourceRow, DWAutoIncrementOption.DWAutoIncrementValueProxy valueProxy) {
        Object value = valueProxy.applyValue(sourceRow, this.batchRows);
        for (List<Object> singleRowParameters : this.batchRowParameters) {
            singleRowParameters.set(targetRowRefParameterIndex, value);
        }
        return value;
    }
}

