/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.dao.constraint;

import com.digiwin.app.dao.DWDao;
import com.digiwin.app.dao.DWQueryInfo;
import com.digiwin.app.dao.DWQueryValueOperator;
import com.digiwin.app.data.DWDataRow;
import com.digiwin.app.data.DWDataSetOperationOption;
import com.digiwin.app.data.DWDataTable;
import com.digiwin.app.data.IDWSQLOptions;
import com.digiwin.app.metadata.DWMetadataContainer;
import com.digiwin.app.metadata.DWValueAttribute;
import com.digiwin.app.metadata.rdbms.DWRdbmsMetadata;
import com.digiwin.app.metadata.rdbms.DWRdbmsRelationshipAttribute;
import com.digiwin.app.module.spring.SpringContextUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class DWReferenceInformation {
    private DWDao dao = (DWDao)SpringContextUtils.getBean((String)"dw-dao");
    static final String PRIMARY_TABLE_NO = "PRIMARY_TABLE_NO";
    String tableName;

    public DWReferenceInformation(String tableName) {
        this.tableName = tableName;
    }

    public List<DWRdbmsRelationshipAttribute> getRelationTableList() {
        DWDataSetOperationOption option = new DWDataSetOperationOption();
        option.setTenantEnabled(false);
        String sql = "SELECT * FROM dw_rdbms_relations WHERE  REFERENCE_TABLE_NO = ?  ";
        List referenceTables = this.dao.select((IDWSQLOptions)option, sql, new Object[]{this.tableName});
        ArrayList<DWRdbmsRelationshipAttribute> relationshipAttributeList = new ArrayList<DWRdbmsRelationshipAttribute>();
        for (Map referenceTable : referenceTables) {
            DWRdbmsMetadata tableMetadata = (DWRdbmsMetadata)DWMetadataContainer.get((String)((String)referenceTable.get(PRIMARY_TABLE_NO)), DWRdbmsMetadata.class);
            Collection relationshipAttributes = tableMetadata.getAttributes(DWRdbmsRelationshipAttribute.class);
            relationshipAttributeList.addAll(relationshipAttributes.stream().filter(item -> item.getDetailTableName().equals(this.tableName)).collect(Collectors.toList()));
        }
        return relationshipAttributeList;
    }

    protected DWDataTable getReferenceDataList(DWRdbmsRelationshipAttribute relationshipAttribute, DWDataRow dataRow, DWDataSetOperationOption option) {
        DWQueryInfo queryInfo = new DWQueryInfo();
        Map<String, String> joinColumns = relationshipAttribute.getJoinColumns();
        queryInfo.setTableName(relationshipAttribute.owner.getName());
        for (Map.Entry<String, String> item : joinColumns.entrySet()) {
            queryInfo.addFieldInfo(item.getKey(), DWQueryValueOperator.Equals, new Object[]{dataRow.get(item.getValue())});
        }
        return this.dao.select(queryInfo, option).getTable(relationshipAttribute.owner.getName());
    }

    protected String getTableDisplayName(DWRdbmsMetadata tableMetadata) {
        DWValueAttribute table_displayName = (DWValueAttribute)tableMetadata.getTableDisplayName();
        return (String)table_displayName.getValue();
    }

    protected String getHintField(DWRdbmsMetadata tableMetadata) {
        return tableMetadata.getHintField();
    }
}

