/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.dao.datasource;

import com.digiwin.app.dao.datasource.DWDataSourceConstants;
import com.digiwin.app.dao.datasource.DWTenantDataSourceException;
import com.digiwin.app.dao.datasource.ITenantDataSource;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.utils.DWTenantUtils;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class DWAbstractTenantDataSource
implements ITenantDataSource {
    private static final Log _log = LogFactory.getLog(DWAbstractTenantDataSource.class);
    private static final String _CLASSTAG = "[DWAbstractTenantDataSource] ";
    protected boolean multipleDatasouce = false;
    protected Object dataSources;
    protected Object dataSourceTenants;
    private String columnTenantSid = DWDataSourceConstants.COLUMN_TENANTSID;
    private String columnTenantDsName = "dsname";
    private String iamTenantSid = DWTenantUtils.getIAMTenantSidKey();

    @Override
    public Object getRunnerFromRepository() {
        if (!this.multipleDatasouce) {
            return null;
        }
        QueryRunner queryRunner = (QueryRunner)this.getQueryRunnerFromRepository(this.getDSNameFromRepository());
        return queryRunner;
    }

    public String getDSNameFromRepository() {
        String dsName = null;
        if (this.dataSourceTenants != null) {
            Map profile = DWServiceContext.getContext().getProfile();
            if (profile != null) {
                boolean isMDS = profile.getOrDefault("multipleTenantDSEnable", true);
                Long tenantsid = (Long)profile.get(this.iamTenantSid);
                if (isMDS && tenantsid != null) {
                    dsName = (String)((Map)this.dataSourceTenants).get(BigInteger.valueOf(tenantsid));
                }
                _log.debug((Object)(_CLASSTAG + this.columnTenantSid + "=" + tenantsid + ", " + this.columnTenantDsName + "=" + dsName + ", multipleDataSource=" + isMDS));
            } else {
                _log.debug((Object)("[DWAbstractTenantDataSource] profile is null or don't contain key 'tenantSid'" + dsName));
            }
        } else {
            _log.debug((Object)"[DWAbstractTenantDataSource] dataSourceTenants is null");
        }
        return dsName;
    }

    public Object getQueryRunnerFromRepository(String dsName) {
        Object result = null;
        if (this.multipleDatasouce && this.dataSources != null && StringUtils.isNotBlank((CharSequence)dsName)) {
            result = ((Map)this.dataSources).get(dsName);
            _log.debug((Object)("[DWAbstractTenantDataSource] using " + dsName));
        }
        return result;
    }

    public QueryRunner getQueryRunnerFromRepositoryByTenant(Object tenantsid) {
        Map dataSourceTenants = (Map)this.getDataSourceTenants();
        String dsName = (String)dataSourceTenants.get(tenantsid);
        QueryRunner queryRunner = (QueryRunner)this.getQueryRunnerFromRepository(dsName);
        _log.debug((Object)("[DWAbstractTenantDataSource] find tenantsid=" + tenantsid + ", get dsname=" + dsName));
        return queryRunner;
    }

    protected void connConfigHandle(BasicDataSource basicDataSource, String connectionProperties) {
        basicDataSource.setConnectionProperties(connectionProperties);
        Map<String, Object> connectProperMap = this.convertConnectionPropertiesToMap(connectionProperties);
        String initialSize = (String)connectProperMap.get("initialSize");
        String maxTotal = (String)connectProperMap.get("maxTotal");
        String maxIdle = (String)connectProperMap.get("maxIdle");
        String minIdle = (String)connectProperMap.get("minIdle");
        String maxWaitMillis = (String)connectProperMap.get("maxWaitMillis");
        if (NumberUtils.isDigits((String)initialSize)) {
            basicDataSource.setInitialSize(Integer.parseInt(initialSize));
        }
        if (NumberUtils.isDigits((String)maxTotal)) {
            basicDataSource.setMaxTotal(Integer.parseInt(maxTotal));
        }
        if (NumberUtils.isDigits((String)maxIdle)) {
            basicDataSource.setMaxIdle(Integer.parseInt(maxIdle));
        }
        if (NumberUtils.isDigits((String)minIdle)) {
            basicDataSource.setMinIdle(Integer.parseInt(minIdle));
        }
        if (NumberUtils.isDigits((String)maxWaitMillis)) {
            basicDataSource.setMaxWaitMillis((long)Integer.parseInt(maxWaitMillis));
        }
    }

    protected Map<String, Object> convertConnectionPropertiesToMap(String connectionProperties) {
        String[] entries = connectionProperties.split(";");
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String entry : entries) {
            int index;
            if (entry.length() <= 0 || (index = entry.indexOf(61)) <= 0) continue;
            String name = entry.substring(0, index);
            String value = entry.substring(index + 1);
            result.put(name, value);
        }
        return result;
    }

    protected void validDataSourceBaseProperty(Object driverClassName, Object url, Object username, Object password) {
        if (Objects.isNull(driverClassName) || StringUtils.isBlank((CharSequence)driverClassName.toString())) {
            throw new DWTenantDataSourceException("DataSource property 'driverClassName' is empty.");
        }
        if (Objects.isNull(url) || StringUtils.isBlank((CharSequence)url.toString())) {
            throw new DWTenantDataSourceException("DataSource property 'url' is empty.");
        }
        if (Objects.isNull(username) || StringUtils.isBlank((CharSequence)username.toString())) {
            throw new DWTenantDataSourceException("DataSource property 'username' is empty.");
        }
        if (Objects.isNull(password) || StringUtils.isBlank((CharSequence)password.toString())) {
            throw new DWTenantDataSourceException("DataSource property 'password' is empty.");
        }
    }

    protected Method findSetterMethod(DataSource dataSource, String propertyName) {
        Class<?> superClazz;
        String setterName = "set" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
        Method setterMethod = null;
        for (Method method : dataSource.getClass().getDeclaredMethods()) {
            if (!setterName.equals(method.getName()) || method.getParameterTypes().length != 1) continue;
            setterMethod = method;
            break;
        }
        if (Objects.isNull(setterMethod) && !Objects.isNull(superClazz = dataSource.getClass().getSuperclass())) {
            for (Method superMethod : superClazz.getDeclaredMethods()) {
                if (!setterName.equals(superMethod.getName()) || superMethod.getParameterTypes().length != 1) continue;
                setterMethod = superMethod;
                break;
            }
        }
        if (Objects.isNull(setterMethod)) {
            throw new DWTenantDataSourceException("DataSource setter method '" + setterName + "' not found.");
        }
        return setterMethod;
    }

    protected Object convertPropertyValue(Object propertyValue, Class<?> parameterType) {
        if (propertyValue == null || parameterType.isInstance(propertyValue)) {
            return propertyValue;
        }
        if (parameterType == String.class) {
            return propertyValue.toString();
        }
        if (parameterType == Integer.class || parameterType == Integer.TYPE) {
            return Integer.parseInt(propertyValue.toString());
        }
        if (parameterType == Boolean.class || parameterType == Boolean.TYPE) {
            return Boolean.parseBoolean(propertyValue.toString());
        }
        if (parameterType == Long.class || parameterType == Long.TYPE) {
            return Long.parseLong(propertyValue.toString());
        }
        throw new IllegalArgumentException("Unsupported conversion from " + propertyValue.getClass() + " to " + parameterType);
    }

    @Override
    public boolean isMultipleDatasouce() {
        return this.multipleDatasouce;
    }

    public void setMultipleDatasouce(boolean multipleDatasouce) {
        this.multipleDatasouce = multipleDatasouce;
    }

    public Object getDataSources() {
        return this.dataSources;
    }

    public void setDataSources(Object dataSources) {
        this.dataSources = dataSources;
    }

    public Object getDataSourceTenants() {
        return this.dataSourceTenants;
    }

    public void setDataSourceTenants(Object dataSourceTenants) {
        this.dataSourceTenants = dataSourceTenants;
    }
}

