/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.dao.datasource.utils;

import com.dap.component.dao.api.ApplicationPropertiesProvider;
import com.dap.component.dao.api.CurrentModuleNameProvider;
import com.dap.component.dao.api.SpringContextProvider;
import com.digiwin.app.dao.datasource.DWTenantDataSourceException;
import com.digiwin.app.module.spring.SpringContextUtils;
import com.google.common.base.CaseFormat;
import com.google.common.base.Joiner;
import javax.sql.DataSource;
import org.springframework.boot.web.servlet.context.AnnotationConfigServletWebServerApplicationContext;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.context.support.GenericXmlApplicationContext;
import org.springframework.util.StringUtils;

public class DWTenantDataSourceUtils {
    public static void registerBean2SpringContext(Object bean, String dsName) {
        ApplicationContext context = null;
        if (DWTenantDataSourceUtils.isModularMode()) {
            String moduleName = DWTenantDataSourceUtils.getModuleName(bean);
            SpringContextProvider springContextProvider = (SpringContextProvider)SpringContextUtils.getBean(SpringContextProvider.class);
            context = springContextProvider.getModuleSpringContext(moduleName);
            if (context == null) {
                context = springContextProvider.getApplicatioSpringContext();
            }
        } else {
            context = SpringContextUtils.getContext();
        }
        if (context == null) {
            throw new DWTenantDataSourceException("Can not find application context");
        }
        String beanId = DWTenantDataSourceUtils.getBeanId(bean, dsName);
        if (context instanceof AnnotationConfigServletWebServerApplicationContext) {
            AnnotationConfigServletWebServerApplicationContext servletWebAppContext = (AnnotationConfigServletWebServerApplicationContext)context;
            servletWebAppContext.getDefaultListableBeanFactory().registerSingleton(beanId, bean);
        } else if (context instanceof GenericXmlApplicationContext) {
            GenericXmlApplicationContext genericXmlAppContext = (GenericXmlApplicationContext)context;
            genericXmlAppContext.getBeanFactory().registerSingleton(beanId, bean);
        } else if (context instanceof AnnotationConfigApplicationContext) {
            AnnotationConfigApplicationContext annotationAppContext = (AnnotationConfigApplicationContext)context;
            annotationAppContext.getDefaultListableBeanFactory().registerSingleton(beanId, bean);
        } else if (context instanceof ClassPathXmlApplicationContext) {
            ClassPathXmlApplicationContext classPathAppContext = (ClassPathXmlApplicationContext)context;
            classPathAppContext.getBeanFactory().registerSingleton(beanId, bean);
        }
    }

    public static String convertKebabToCamelCase(String kebabCase) {
        if (!StringUtils.hasText((String)kebabCase) && !kebabCase.contains("-")) {
            return kebabCase;
        }
        return CaseFormat.LOWER_HYPHEN.to(CaseFormat.LOWER_CAMEL, kebabCase);
    }

    private static String capitalize(String str) {
        if (!StringUtils.hasText((String)str)) {
            return str;
        }
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }

    private static String getBeanId(Object bean, String dsName) {
        return Joiner.on((String)"-").join((Object)dsName, (Object)bean.getClass().getSimpleName(), new Object[0]);
    }

    private static boolean isModularMode() {
        boolean isModularMode = true;
        try {
            DWTenantDataSourceUtils.class.getClassLoader().loadClass("com.digiwin.app.event.simplified.DWSimplifiedApolloApplicationListener");
            isModularMode = false;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return isModularMode;
    }

    private static String getModuleName(Object service) {
        ClassLoader classLoader = null;
        classLoader = service instanceof Class ? ((Class)service).getClassLoader() : service.getClass().getClassLoader();
        CurrentModuleNameProvider currentModuleNameProvider = (CurrentModuleNameProvider)SpringContextUtils.getBean(CurrentModuleNameProvider.class);
        String moduleName = currentModuleNameProvider.get(classLoader);
        return moduleName;
    }

    public static Object newDataSourceProxyInstance(DataSource dataSource) {
        DataSource dsProxyInstance = dataSource;
        ApplicationPropertiesProvider applicationPropertiesProvider = (ApplicationPropertiesProvider)SpringContextUtils.getBean(ApplicationPropertiesProvider.class);
        if (Boolean.parseBoolean(applicationPropertiesProvider.getValue("seata.enabled", "false"))) {
            try {
                Class<?> dataSourceClazz = Class.forName("io.seata.rm.datasource.DataSourceProxy");
                dsProxyInstance = dataSourceClazz.getDeclaredConstructor(DataSource.class).newInstance(dataSource);
            }
            catch (Exception e) {
                throw new DWTenantDataSourceException("Failed to create 'io.seata.rm.datasource.DataSourceProxy' instance", e);
            }
        }
        return dsProxyInstance;
    }
}

