/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.metadata.rdbms;

import com.digiwin.app.metadata.DWMetadataContainer;
import com.digiwin.app.metadata.DWNamedAttribute;
import com.digiwin.app.metadata.rdbms.DWRdbmsMetadata;
import com.digiwin.app.metadata.rdbms.DWRdbmsRelationType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class DWRdbmsRelationshipAttribute
extends DWNamedAttribute {
    public static String NAME = "rdbms.relationship";
    public DWRdbmsMetadata owner;
    private String detailTableName;
    private Map<String, String> joinColumns = new HashMap<String, String>();
    private DWRdbmsRelationType type = DWRdbmsRelationType.Auto;
    private boolean isOneToOne;
    private boolean isOneToMany;
    private boolean init = false;

    public DWRdbmsRelationshipAttribute(DWRdbmsMetadata owner, String detailTableName) {
        this();
        if (owner == null) {
            throw new IllegalArgumentException("owner is null!");
        }
        this.owner = owner;
        this.detailTableName = detailTableName;
    }

    public DWRdbmsRelationshipAttribute() {
        super(NAME);
    }

    public void setType(DWRdbmsRelationType type) {
        if (type == null) {
            this.type = DWRdbmsRelationType.Auto;
        }
        if (this.type != type) {
            this.init = false;
        }
        this.type = type;
    }

    public DWRdbmsRelationType getType() {
        return this.type;
    }

    public void addJoinColumn(String columnName, String detailColumnName) {
        this.joinColumns.put(columnName, detailColumnName);
    }

    public String getDetailTableName() {
        return this.detailTableName;
    }

    public Map<String, String> getJoinColumns() {
        return Collections.unmodifiableMap(this.joinColumns);
    }

    public boolean isOneToOne() {
        this.analyze();
        return this.isOneToOne;
    }

    public boolean isOneToMany() {
        this.analyze();
        return this.isOneToMany;
    }

    private void analyze() {
        if (this.init) {
            return;
        }
        this.init = true;
        if (this.type != DWRdbmsRelationType.Auto) {
            this.isOneToOne = this.type == DWRdbmsRelationType.OneToOne;
            this.isOneToMany = this.type == DWRdbmsRelationType.OneToMany;
            return;
        }
        DWRdbmsMetadata targetMetadata = (DWRdbmsMetadata)DWMetadataContainer.get((String)this.detailTableName, DWRdbmsMetadata.class);
        Collection targetPrimaryKeys = targetMetadata.getPrimaryKeys();
        Collection<String> targetJoinKeys = this.getJoinColumns().values();
        boolean bl = this.isOneToMany = targetPrimaryKeys.size() > targetJoinKeys.size();
        if (!this.isOneToMany) {
            this.isOneToOne = this.allMatched(targetJoinKeys, targetPrimaryKeys);
            if (this.isOneToOne) {
                Set<String> primaryJoinKeys = this.getJoinColumns().keySet();
                Collection primaryTableKeys = this.owner.getPrimaryKeys();
                this.isOneToMany = primaryJoinKeys.stream().allMatch(pjk -> primaryTableKeys.contains(pjk));
                this.isOneToOne = false;
            }
        }
        this.init = true;
    }

    private boolean allMatched(Collection<String> targetJoinKeys, Collection<String> targetPrimaryKeys) {
        return targetPrimaryKeys.stream().allMatch(pk -> targetJoinKeys.contains(pk));
    }
}

