/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.dao.filter;

import com.digiwin.app.dao.filter.DWAbstractFieldNameResolver;
import com.digiwin.app.data.DWDataRow;
import com.digiwin.app.metadata.DWMetadataContainer;
import com.digiwin.app.metadata.rdbms.DWRdbmsField;
import com.digiwin.app.metadata.rdbms.DWRdbmsMetadata;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DWPrimaryKeyFieldNameResolver
extends DWAbstractFieldNameResolver {
    private static Log log = LogFactory.getLog(DWPrimaryKeyFieldNameResolver.class);
    private Map<String, String> map = new ConcurrentHashMap<String, String>();

    @Override
    public String getRealName(DWDataRow dataRow) {
        String tableName = dataRow.getDataTable().getName();
        String primaryKey = this.map.get(tableName);
        if (primaryKey == null && this.map.putIfAbsent(tableName, primaryKey = this.getPrimaryKey(tableName)) == null) {
            log.info((Object)("\u521d\u59cb\u5316\u63d2\u5165\u8868\u7684\u4e3b\u952e\uff1a" + tableName + "--->" + primaryKey));
        }
        return primaryKey;
    }

    private String getPrimaryKey(String tableName) {
        DWRdbmsField field;
        String valueType;
        DWRdbmsMetadata metadata = (DWRdbmsMetadata)DWMetadataContainer.get((String)tableName, DWRdbmsMetadata.class);
        List list = metadata.getPrimaryKeys().stream().filter(Objects::nonNull).collect(Collectors.toList());
        String primaryKey = "";
        if (list.size() == 1 && !"INT".equalsIgnoreCase(valueType = (field = (DWRdbmsField)metadata.getField(primaryKey = (String)list.get(0))).getValueType())) {
            log.info((Object)(tableName + "\u8868\u7684\u4e3b\u952e\u3010" + primaryKey + "\u3011\u4e0d\u662f\u6570\u503c\u7c7b\u578b\uff0c\u4e0d\u4e88\u81ea\u52a8\u63d2\u5165\u3002"));
            primaryKey = "";
        }
        return primaryKey;
    }
}

