/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.data;

import com.digiwin.app.data.DWDataRow;
import com.digiwin.app.data.DWDataRowCollection;
import com.digiwin.app.data.DWDataSet;
import com.digiwin.app.data.DWDataSetConverter;
import com.digiwin.app.data.DWDataTable;
import com.digiwin.app.data.DWRowHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DWDataSetTableListConverter
implements DWDataSetConverter {
    public Map<String, Object> toMap(DWDataSet dataset) {
        HashMap<String, Object> syncMap = new HashMap<String, Object>();
        for (DWDataTable tb : dataset.getTables()) {
            ArrayList<Map<String, Object>> tableRowList = new ArrayList<Map<String, Object>>();
            syncMap.put(tb.getName(), tableRowList);
            this.synchronizeToSourceMap(tb.getRows(), tableRowList);
        }
        return syncMap;
    }

    protected void synchronizeToSourceMap(DWDataRowCollection rowCollection, List<Map<String, Object>> tableRowList) {
        Iterator removedRows = rowCollection.getIteratorOfRemovedRows();
        while (removedRows.hasNext()) {
            this.synchronizeToSourceMap((DWDataRow)removedRows.next(), tableRowList);
        }
        for (DWDataRow row : rowCollection) {
            this.synchronizeToSourceMap(row, tableRowList);
        }
    }

    protected void synchronizeToSourceMap(DWDataRow processRow, List<Map<String, Object>> tableRowList) {
        Map<String, Object> rawRawData = this.getRawDataMap(processRow.getSourceData());
        tableRowList.add(rawRawData);
    }

    protected Map<String, Object> getRawDataMap(Map<String, Object> rowSourceData) {
        DWRowHashMap rawMap = new DWRowHashMap();
        rawMap.putAll(rowSourceData);
        ArrayList removedChildKeyList = new ArrayList();
        for (Map.Entry item : rawMap.entrySet()) {
            if (!(item.getValue() instanceof DWDataRowCollection)) continue;
            removedChildKeyList.add(item.getKey());
        }
        removedChildKeyList.stream().forEach(arg_0 -> DWDataSetTableListConverter.lambda$getRawDataMap$14((Map)rawMap, arg_0));
        return rawMap;
    }

    private static /* synthetic */ void lambda$getRawDataMap$14(Map rawMap, String key) {
        rawMap.remove(key);
    }
}

