/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.data.permission.row.condition;

import com.digiwin.app.dao.DWQueryCondition;
import com.digiwin.app.dao.DWQueryValueOperator;
import com.digiwin.app.dao.DWSqlInfo;
import com.digiwin.data.permission.DWPermissionConditionSingleValueBase;
import com.digiwin.data.permission.DWPermissionOperator;
import com.digiwin.data.permission.DWRowPermissionMatchOption;
import java.util.ArrayList;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class DWPermissionLikeCondition
extends DWPermissionConditionSingleValueBase {
    private static final String LIKE_PERCENT = "%";

    @Override
    protected boolean matchCoreSingleValue(Object data, DWPermissionOperator operator, Object conditionValue) {
        return conditionValue == null ? data == null : conditionValue.equals(data);
    }

    @Override
    protected boolean isSupport(DWPermissionOperator operator) {
        return operator == DWPermissionOperator.Like || operator == DWPermissionOperator.ll || operator == DWPermissionOperator.rl;
    }

    @Override
    protected DWSqlInfo getSQLCoreSingleValue(String fieldName, DWPermissionOperator operator, Object conditionValue, DWRowPermissionMatchOption option) {
        StringBuilder sql = new StringBuilder();
        ArrayList<String> params = new ArrayList<String>();
        sql.append(fieldName);
        sql.append(" ").append(operator.getValue().toUpperCase() + " ? ");
        if (operator == DWPermissionOperator.Like) {
            params.add(" '%" + conditionValue + "%'");
        } else if (operator == DWPermissionOperator.ll) {
            params.add(" '%" + conditionValue + "'");
        } else if (operator == DWPermissionOperator.rl) {
            params.add(" '" + conditionValue + "%'");
        }
        return new DWSqlInfo(sql.toString(), params);
    }

    @Override
    protected String getSQLContainValuesCoreSingleValue(String fieldName, DWPermissionOperator operator, Object conditionValue, DWRowPermissionMatchOption option) {
        StringBuilder sql = new StringBuilder();
        sql.append(fieldName);
        sql.append(" ").append(operator.getValue().toUpperCase());
        if (operator == DWPermissionOperator.Like) {
            sql.append(" '%" + conditionValue + "%'");
        } else if (operator == DWPermissionOperator.ll) {
            sql.append(" '%" + conditionValue + "'");
        } else if (operator == DWPermissionOperator.rl) {
            sql.append(" '" + conditionValue + "%'");
        }
        return sql.toString();
    }

    @Override
    protected DWQueryCondition getQueryConditionCoreSingleValue(String fieldName, DWPermissionOperator operator, Object conditionValue, DWRowPermissionMatchOption option) {
        DWQueryCondition queryCondition = new DWQueryCondition();
        if (Objects.isNull((Object)operator)) {
            return queryCondition;
        }
        String likeValue = this.buildValue(operator, conditionValue);
        if (StringUtils.isNotBlank((CharSequence)likeValue)) {
            queryCondition.addFieldInfo(fieldName, DWQueryValueOperator.Like, new Object[]{likeValue});
        }
        return queryCondition;
    }

    protected String buildValue(DWPermissionOperator operator, Object conditionValue) {
        String likeValue = "";
        switch (operator) {
            case Like: {
                likeValue = LIKE_PERCENT + conditionValue + LIKE_PERCENT;
                break;
            }
            case ll: {
                likeValue = LIKE_PERCENT + conditionValue;
                break;
            }
            case rl: {
                likeValue = conditionValue + LIKE_PERCENT;
                break;
            }
        }
        return likeValue;
    }
}

