/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.data.permission.controller;

import com.digiwin.app.json.gson.DWGsonProvider;
import com.digiwin.data.permission.controller.DWDataPermissionSchemasParameters;
import com.digiwin.data.permission.controller.DWDataPermissionValuesParameters;
import com.digiwin.data.permission.controller.IDWDataPermissionMetadataProvider;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@RestController
@Validated
public class DWDataPermissionController {
    @Autowired
    private IDWDataPermissionMetadataProvider schemasProvider;
    Gson gson = DWGsonProvider.getGson();
    static final String KEY_NAME = "name";
    static final String KEY_NAME_ = "name_";
    static final String KEY_ID = "id";
    static final String KEY_ITEMS = "items";
    static final String KEY_FIELDS = "fields";
    static final String KEY_DATA_TYPE = "dataType";
    static final String KEY_DATA_SOURCE = "dataSource";
    static final String KEY_FILTER_TYPE = "filterType";

    public String getSchemas(@Valid @ModelAttribute DWDataPermissionSchemasParameters parameters) {
        String schemas = this.schemasProvider.getSchema(parameters);
        return this.getSchemasWithAcceptLanguage(schemas);
    }

    public String getValues(@Valid @RequestBody DWDataPermissionValuesParameters parameters) {
        String values = this.schemasProvider.getValues(parameters);
        return this.getValuesWithAcceptLanguage(values);
    }

    private String getSchemasWithAcceptLanguage(String jsonString) {
        String language = this.getLanguage();
        JsonArray jsonArray = JsonParser.parseString((String)jsonString).getAsJsonArray();
        JsonArray filteredJsonArray = this.filterJsonArrayByLanguage(jsonArray, language);
        return this.gson.toJson((JsonElement)filteredJsonArray);
    }

    private String getValuesWithAcceptLanguage(String jsonString) {
        JsonObject root = (JsonObject)this.gson.fromJson(jsonString, JsonObject.class);
        JsonArray items = root.getAsJsonArray(KEY_ITEMS);
        if (items != null) {
            String nameKey = KEY_NAME_ + this.getLanguage();
            for (JsonElement itemElement : items) {
                JsonObject item = itemElement.getAsJsonObject();
                if (item.has(nameKey)) {
                    item.addProperty(KEY_NAME, item.get(nameKey).getAsString());
                }
                item.entrySet().removeIf(entry -> ((String)entry.getKey()).startsWith(KEY_NAME_));
            }
        }
        return this.gson.toJson((JsonElement)root);
    }

    private String getLanguage() {
        String language = null;
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (Objects.nonNull(attributes)) {
            HttpServletRequest request = attributes.getRequest();
            language = request.getHeader("Accept-Language");
        }
        if (Objects.isNull(language)) {
            language = "";
        }
        language = language.replace("-", "_");
        return language;
    }

    private JsonArray filterJsonArrayByLanguage(JsonArray jsonArray, String language) {
        JsonArray resultArray = new JsonArray();
        for (JsonElement element : jsonArray) {
            JsonObject originalObj = element.getAsJsonObject();
            JsonObject newObj = new JsonObject();
            newObj.addProperty(KEY_ID, originalObj.get(KEY_ID).getAsString());
            String nameKey = KEY_NAME_ + language;
            if (originalObj.has(nameKey)) {
                newObj.addProperty(KEY_NAME, originalObj.get(nameKey).getAsString());
            } else {
                newObj.addProperty(KEY_NAME, originalObj.get(KEY_NAME).getAsString());
            }
            JsonArray fields = originalObj.getAsJsonArray(KEY_FIELDS);
            JsonArray filteredFields = DWDataPermissionController.filterFields(fields, language);
            newObj.add(KEY_FIELDS, (JsonElement)filteredFields);
            resultArray.add((JsonElement)newObj);
        }
        return resultArray;
    }

    private static JsonArray filterFields(JsonArray fieldsJsonArray, String language) {
        JsonArray filteredFieldsArray = new JsonArray();
        for (JsonElement fieldElement : fieldsJsonArray) {
            JsonObject fieldObj = fieldElement.getAsJsonObject();
            JsonObject newFieldObj = new JsonObject();
            newFieldObj.addProperty(KEY_ID, fieldObj.get(KEY_ID).getAsString());
            String nameKey = KEY_NAME_ + language;
            if (fieldObj.has(nameKey)) {
                newFieldObj.addProperty(KEY_NAME, fieldObj.get(nameKey).getAsString());
            } else {
                newFieldObj.addProperty(KEY_NAME, fieldObj.get(KEY_NAME).getAsString());
            }
            newFieldObj.addProperty(KEY_DATA_TYPE, fieldObj.get(KEY_DATA_TYPE).getAsString());
            if (fieldObj.has(KEY_DATA_SOURCE)) {
                newFieldObj.addProperty(KEY_DATA_SOURCE, fieldObj.get(KEY_DATA_SOURCE).getAsString());
            }
            if (fieldObj.has(KEY_FILTER_TYPE)) {
                newFieldObj.add(KEY_FILTER_TYPE, fieldObj.get(KEY_FILTER_TYPE));
            }
            filteredFieldsArray.add((JsonElement)newFieldObj);
        }
        return filteredFieldsArray;
    }
}

