/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.data.permission.column.processor;

import com.digiwin.app.data.DWDataRow;
import com.digiwin.app.data.exceptions.ExecuteException;
import com.digiwin.data.permission.column.bo.DWColumnPermissionElement;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DWPermissionColumnProcessor {
    private static Set<String> PRIMITIVE_TYPE_CLASS_NAMES = new HashSet<String>();

    public static void process(Object data, List<DWColumnPermissionElement> colPermissionElements) {
        if (data instanceof Map) {
            Map dataMap = (Map)data;
            HashSet<String> dataMapKeySet = new HashSet<String>();
            for (String dataMapKey : dataMap.keySet()) {
                dataMapKeySet.add(dataMapKey);
            }
            for (String fieldName : dataMapKeySet) {
                if (DWPermissionColumnProcessor.isFieldInColPermission(fieldName, colPermissionElements)) continue;
                Object desensitizedData = DWPermissionColumnProcessor.desensitize(dataMap.get(fieldName));
                dataMap.put(fieldName, desensitizedData);
            }
        } else {
            Field[] fields;
            for (Field field : fields = data.getClass().getDeclaredFields()) {
                if (DWPermissionColumnProcessor.isFieldInColPermission(field.getName(), colPermissionElements)) continue;
                field.setAccessible(true);
                try {
                    Object desensitizedData = DWPermissionColumnProcessor.desensitize(field.get(data));
                    field.set(data, desensitizedData);
                }
                catch (IllegalArgumentException e) {
                    throw new ExecuteException((Throwable)e);
                }
                catch (IllegalAccessException e) {
                    throw new ExecuteException((Throwable)e);
                }
            }
        }
    }

    public static void process(DWDataRow data, List<DWColumnPermissionElement> colPermissionElements) {
        String tableName = data.getDataTable().getName();
        Map dataRowData = data.getData();
        for (Map.Entry dataMapEntry : dataRowData.entrySet()) {
            String fieldName = (String)dataMapEntry.getKey();
            if (DWPermissionColumnProcessor.isFieldInColPermission(tableName, fieldName, colPermissionElements)) continue;
            Object desensitizedData = DWPermissionColumnProcessor.desensitize(dataMapEntry.getValue());
            data.set(fieldName, desensitizedData);
        }
    }

    private static boolean isFieldInColPermission(String fieldName, List<DWColumnPermissionElement> colPermissionElements) {
        boolean result = false;
        for (DWColumnPermissionElement colPermissionElement : colPermissionElements) {
            for (String colPermissionFieldName : colPermissionElement.getFields()) {
                if (!colPermissionFieldName.equalsIgnoreCase(fieldName)) continue;
                result = true;
                return result;
            }
        }
        return result;
    }

    private static boolean isFieldInColPermission(String tableName, String fieldName, List<DWColumnPermissionElement> colPermissionElements) {
        boolean result = false;
        for (DWColumnPermissionElement colPermissionElement : colPermissionElements) {
            if (!colPermissionElement.getTable().equals(tableName)) continue;
            for (String colPermissionFieldName : colPermissionElement.getFields()) {
                if (!colPermissionFieldName.equalsIgnoreCase(fieldName)) continue;
                result = true;
                return result;
            }
        }
        return result;
    }

    private static Object desensitize(Object data) {
        if (data != null && !PRIMITIVE_TYPE_CLASS_NAMES.contains(data.getClass().getName())) {
            data = null;
            return data;
        }
        return data;
    }

    static {
        PRIMITIVE_TYPE_CLASS_NAMES.add(Boolean.TYPE.getName());
        PRIMITIVE_TYPE_CLASS_NAMES.add(Byte.TYPE.getName());
        PRIMITIVE_TYPE_CLASS_NAMES.add(Character.TYPE.getName());
        PRIMITIVE_TYPE_CLASS_NAMES.add(Double.TYPE.getName());
        PRIMITIVE_TYPE_CLASS_NAMES.add(Float.TYPE.getName());
        PRIMITIVE_TYPE_CLASS_NAMES.add(Integer.TYPE.getName());
        PRIMITIVE_TYPE_CLASS_NAMES.add(Long.TYPE.getName());
        PRIMITIVE_TYPE_CLASS_NAMES.add(Short.TYPE.getName());
    }
}

