/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.autoconfigure;

import com.dap.component.documentid.api.DapDocumentIdFinder;
import com.dap.component.documentid.api.DapDocumentIdGenerator;
import com.digiwin.app.autoconfigure.DWRedisAutoConfiguration;
import com.digiwin.app.redis.service.DWRedisService;
import com.digiwin.properties.DocumentIdProperties;
import com.digiwin.util.DocumentIdFinder;
import com.digiwin.util.DocumentIdGenerator;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.core.env.Environment;

@ConditionalOnBean(value={DWRedisService.class})
@AutoConfigureAfter(value={DWRedisAutoConfiguration.class})
@DependsOn(value={"dw-spring-context-utils", "dw-json-config"})
@Configuration
public class DWDocumentIdAutoConfiguration {
    @Bean
    public DocumentIdGenerator documentIdGenerator() {
        return new DocumentIdGenerator();
    }

    @Bean
    @ConditionalOnMissingBean
    public DapDocumentIdGenerator dapDocumentIdGenerator() {
        return new DocumentIdGenerator();
    }

    @Bean
    public DocumentIdFinder documentIdFinder() {
        return new DocumentIdFinder();
    }

    @Bean
    @ConditionalOnMissingBean
    public DapDocumentIdFinder dapDocumentIdFinder() {
        return new DocumentIdFinder();
    }

    @Bean
    public DocumentIdProperties documentIdProperties(Environment environment) {
        DocumentIdProperties documentIdProperties = new DocumentIdProperties();
        documentIdProperties.setAccurateRuleMatchEnable(Boolean.parseBoolean(environment.getProperty("dwDocumentId.accurateRuleMatch.enabled", "false").trim()));
        documentIdProperties.setSerialLengthOutOfBoundsExceptionEnable(Boolean.parseBoolean(environment.getProperty("dwDocumentId.serialLengthOutOfBoundsException.enabled", "false")));
        return documentIdProperties;
    }
}

