/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.util;

import com.dap.component.documentid.api.DapDocumentIdGenerator;
import com.digiwin.app.data.exceptions.DWDataException;
import com.digiwin.app.redis.service.DWRedisService;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.dto.DocumentIdInfo;
import com.digiwin.exception.DWSerialLengthOutOfBoundsException;
import com.digiwin.util.DocumentIdFinder;
import com.digiwin.util.DocumentIdFormatter;
import com.digiwin.util.DocumentIdSetting;
import com.digiwin.utils.DWTenantUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.script.DefaultRedisScript;
import org.springframework.data.redis.core.script.RedisScript;

public class DocumentIdGenerator
implements DapDocumentIdGenerator {
    private static final Log logger = LogFactory.getLog(DocumentIdGenerator.class);
    private DocumentIdFormatter formatter = new DocumentIdFormatter();
    private String appId;
    @Autowired
    private DocumentIdFinder finder;
    @Autowired
    private DWRedisService redisTemplate;
    private String redisPrefixFolder = "DAP:DocumentId";

    @Value(value="${appId:}")
    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getId(DocumentIdSetting setting) throws Exception {
        if (setting != null && setting.getNumber() > 1) {
            throw new DWDataException("setting.setNumber can't greater than 1");
        }
        String result = this.generateId(setting).get(0);
        return result;
    }

    public List<String> getIdList(DocumentIdSetting setting) throws Exception {
        List<String> result = this.generateId(setting);
        return result;
    }

    private List<String> generateId(DocumentIdSetting setting) throws Exception {
        if (setting == null) {
            throw new DWDataException("DocumentIdSetting can'n be null ");
        }
        ArrayList<String> result = new ArrayList<String>();
        List<Long> serialIds = this.generateSerialId(setting);
        for (long serialId : serialIds) {
            result.add(this.formatter.format(serialId, setting));
            logger.debug((Object)("serialId:" + serialId));
        }
        return result;
    }

    private List<Long> generateSerialId(DocumentIdSetting setting) throws Exception {
        long startId;
        Long maxSerialNo;
        long maxSerialNoInRedis;
        ArrayList<Long> result = new ArrayList<Long>();
        String redisKeyGroup = this.generateRedisKeyGroup(setting);
        RedisTemplate origRedisTemplate = (RedisTemplate)this.redisTemplate.getOperator();
        String redisGroupLock = redisKeyGroup + ":lock";
        while (true) {
            DefaultRedisScript defaultRedisScript = new DefaultRedisScript();
            defaultRedisScript.setResultType(Long.class);
            defaultRedisScript.setScriptText("if redis.call('setnx', KEYS[1], ARGV[1]) == 1 then redis.call('pexpire', KEYS[1], ARGV[2]) return 1 else return 0 end");
            List<String> keyList = Arrays.asList(redisGroupLock);
            Long getLock = (Long)origRedisTemplate.execute((RedisScript)defaultRedisScript, keyList, new Object[]{1, 30000});
            if (getLock == 1L) {
                Long startSerialNo;
                if (!this.redisTemplate.hasKey(redisKeyGroup).booleanValue()) {
                    long maxSerialNo2 = 0L;
                    String documentId = this.finder.getMaxSerialNo(setting.getGroup(), setting);
                    if (documentId != null && !documentId.equals("")) {
                        maxSerialNo2 = this.formatter.getSerialNo(documentId, setting);
                    }
                    if (!this.redisTemplate.set(redisKeyGroup, (Object)maxSerialNo2).booleanValue()) {
                        throw new Exception(String.format("%s generate documentid exception caused by redis set operation error", redisKeyGroup));
                    }
                }
                maxSerialNoInRedis = Long.parseLong(this.redisTemplate.get(redisKeyGroup).toString());
                maxSerialNo = maxSerialNoInRedis;
                if (setting.getStartSerialNo() != null && (startSerialNo = setting.getStartSerialNo()) > maxSerialNo) {
                    maxSerialNo = startSerialNo - 1L;
                }
                maxSerialNo = maxSerialNo + (long)setting.getNumber();
                if (setting.isSerialLengthOutOfBoundsExceptionEnable() && maxSerialNo.toString().length() > setting.getSerialIdLength()) {
                    throw new DWSerialLengthOutOfBoundsException("serial length was out of bounds");
                }
                break;
            }
            Thread.sleep(500L);
        }
        long currentId = this.redisTemplate.incrBy(redisKeyGroup, maxSerialNo - maxSerialNoInRedis);
        origRedisTemplate.delete((Object)redisGroupLock);
        for (long i = startId = currentId - (long)setting.getNumber() + 1L; i <= currentId; ++i) {
            result.add(i);
            logger.debug((Object)("Fetch redis serialNo=" + i));
        }
        return result;
    }

    public List<Map<String, Object>> deleteIdList(List<DocumentIdInfo> params) throws Exception {
        this.paramVarify(params);
        ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>();
        for (DocumentIdInfo param : params) {
            String[] keys;
            Integer maxSeriaNo;
            String redisKeyGroup;
            List ids = param.getIds();
            DocumentIdSetting setting = param.getSetting();
            HashMap<String, Object> result = new HashMap<String, Object>();
            if (ids != null && ids.size() > 0) {
                redisKeyGroup = this.generateRedisKeyGroup(setting);
                maxSeriaNo = 0;
                if (!this.redisTemplate.hasKey(redisKeyGroup).booleanValue()) {
                    String documentId = this.finder.getMaxSerialNo(setting.getGroup(), setting);
                    if (documentId != null && !documentId.equals("")) {
                        maxSeriaNo = this.formatter.fetchSerialNo(documentId, setting);
                    }
                    if (maxSeriaNo != 0) {
                        this.redisTemplate.set(redisKeyGroup, (Object)maxSeriaNo);
                    }
                } else {
                    maxSeriaNo = (Integer)this.redisTemplate.get(redisKeyGroup);
                }
                keys = redisKeyGroup.split(":");
                if (maxSeriaNo == 0) {
                    result.put("group", String.format("%s{%s}", keys[keys.length - 1], setting.getSerialIdLength()));
                    result.put("maxSerialNo", maxSeriaNo);
                    results.add(result);
                    continue;
                }
                List idLst = ids.stream().map(id -> {
                    try {
                        return this.formatter.fetchSerialNo(id, setting);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }).sorted(Comparator.comparing(id -> id, (id1, id2) -> Integer.compare(id2, id1))).collect(Collectors.toList());
                Iterator iterator = idLst.iterator();
                boolean startMatchFlag = false;
                while (iterator.hasNext()) {
                    if (iterator.next().equals(maxSeriaNo)) {
                        startMatchFlag = true;
                        Integer n = maxSeriaNo;
                        maxSeriaNo = maxSeriaNo - 1;
                        continue;
                    }
                    if (!startMatchFlag) continue;
                }
                this.redisTemplate.set(redisKeyGroup, (Object)maxSeriaNo);
                result.put("group", String.format("%s{%s}", keys[keys.length - 1], setting.getSerialIdLength()));
                result.put("maxSerialNo", maxSeriaNo);
                results.add(result);
                continue;
            }
            redisKeyGroup = this.generateRedisKeyGroup(setting);
            maxSeriaNo = (Integer)this.redisTemplate.get(redisKeyGroup);
            keys = redisKeyGroup.split(":");
            result.put("group", String.format("%s{%s}", keys[keys.length - 1], setting.getSerialIdLength()));
            result.put("maxSerialNo", maxSeriaNo);
            results.add(result);
            this.redisTemplate.remove(new String[]{redisKeyGroup});
        }
        return results;
    }

    private String generateRedisKeyGroup(DocumentIdSetting setting) throws Exception {
        StringBuilder redisKeyGroup = new StringBuilder();
        redisKeyGroup.append(this.redisPrefixFolder).append(":").append(this.appId).append(":");
        redisKeyGroup.append(setting.getTableName()).append(":").append(setting.getColumnName()).append(":");
        if (setting.isTenant()) {
            Map profile = DWServiceContext.getContext().getProfile();
            redisKeyGroup.append(profile.get(DWTenantUtils.getIAMTenantSidKey())).append(":");
        }
        Object group = setting.getGroup();
        String serialPrefix = setting.getSerialPrefix();
        if (StringUtils.isNotBlank((CharSequence)serialPrefix)) {
            group = (String)group + serialPrefix;
        }
        if (setting.isAccurateRuleMatchEnable()) {
            redisKeyGroup.append((String)group).append("{" + setting.getSerialIdLength() + "}").append(setting.getSuffix());
        } else {
            redisKeyGroup.append((String)group).append(setting.getSuffix());
        }
        logger.debug((Object)("current redisKeyGroup is " + redisKeyGroup.toString()));
        return redisKeyGroup.toString();
    }

    private void paramVarify(List<DocumentIdInfo> params) {
        if (params != null & params.size() > 0) {
            for (DocumentIdInfo param : params) {
                DocumentIdSetting setting = param.getSetting();
                String tableName = setting.getTableName();
                String columnName = setting.getColumnName();
                if (tableName == null || columnName == null) {
                    throw new RuntimeException("setting tableName or columnName can't be null");
                }
                if (param.getIds() == null) continue;
                param.getIds().forEach(id -> {
                    String settingGroup = "";
                    try {
                        settingGroup = setting.getGroup();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    String idGroup = id.substring(0, settingGroup.length());
                    String idSerialNoStr = id.substring(settingGroup.length(), id.lastIndexOf(setting.getSuffix()));
                    if (!idGroup.equals(settingGroup) || setting.isSerialLengthOutOfBoundsExceptionEnable() && idSerialNoStr.length() != setting.getSerialIdLength()) {
                        throw new RuntimeException(String.format("id :%s not match the setting pattern:%s{%s}", id, settingGroup, setting.getSerialIdLength()));
                    }
                });
            }
        }
    }
}

