/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.eai.util;

import com.dap.component.eai.api.ConfigProvider;
import com.dap.component.eai.api.ProfileProvider;
import com.digiwin.app.module.spring.SpringContextUtils;
import com.digiwin.dap.middleware.lmc.LMCClient;
import com.digiwin.dap.middleware.lmc.request.SaveEventLog;
import com.digiwin.dap.middleware.lmc.util.JsonUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class LmcUtil {
    private static Log log = LogFactory.getLog(LmcUtil.class);
    private static LMCClient LMCCLIENT_INSTANCE = null;

    public static void callbackEvent(Header[] header, Map<String, Object> body, Map<String, Object> requestHeader, long timestamp) {
        try {
            SaveEventLog saveEventLog = LmcUtil.getSaveEventLog("callback");
            saveEventLog.setStatus(Integer.valueOf(0));
            Map<String, Object> requestHeaderMap = LmcUtil.convertMap(requestHeader);
            Map<String, Object> headerMap = LmcUtil.headerArrayToMap(header);
            HashMap<String, Object> content = new HashMap<String, Object>();
            content.put("requestHeader", requestHeaderMap);
            content.put("timestamp", timestamp);
            content.put("header", headerMap);
            content.put("body", body);
            saveEventLog.setContent(content);
            LmcUtil.saveEventLog(saveEventLog);
        }
        catch (Exception e) {
            String message = ExceptionUtils.getMessage((Throwable)e);
            log.error((Object)("[LmcUtil] " + message), (Throwable)e);
        }
    }

    public static void callbackRtnEventOnException(Throwable throwable, Map<String, Object> requestHeader, long timestamp) {
        try {
            SaveEventLog saveEventLog = LmcUtil.getSaveEventLog("callbackRtn");
            saveEventLog.setStatus(Integer.valueOf(1));
            Map<String, Object> requestHeaderMap = LmcUtil.convertMap(requestHeader);
            String errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)throwable);
            String stackTrace = ExceptionUtils.getStackTrace((Throwable)throwable);
            HashMap<String, String> debugInfo = new HashMap<String, String>();
            debugInfo.put("stackTrace", stackTrace);
            HashMap<String, Object> content = new HashMap<String, Object>();
            content.put("requestHeader", requestHeaderMap);
            content.put("timestamp", timestamp);
            content.put("httpStatus", null);
            content.put("errorMessage", errorMessage);
            content.put("debugInfo", debugInfo);
            content.put("header", "");
            content.put("body", "");
            saveEventLog.setContent(content);
            LmcUtil.saveEventLog(saveEventLog);
        }
        catch (Exception e) {
            String message = ExceptionUtils.getMessage((Throwable)e);
            log.error((Object)("[LmcUtil] " + message), (Throwable)e);
        }
    }

    public static void callbackRtnEvent(Header[] header, String body, Map<String, Object> requestHeader, long timestamp) {
        try {
            SaveEventLog saveEventLog = LmcUtil.getSaveEventLog("callbackRtn");
            saveEventLog.setStatus(Integer.valueOf(0));
            Map<String, Object> requestHeaderMap = LmcUtil.convertMap(requestHeader);
            Map<String, Object> headerMap = LmcUtil.headerArrayToMap(header);
            Map bodyMap = (Map)JsonUtils.readValue((String)body, (TypeReference)new TypeReference<Map<String, Object>>(){});
            HashMap<String, Object> content = new HashMap<String, Object>();
            content.put("requestHeader", requestHeaderMap);
            content.put("timestamp", timestamp);
            content.put("httpStatus", 200);
            content.put("header", headerMap);
            content.put("body", bodyMap);
            saveEventLog.setContent(content);
            LmcUtil.saveEventLog(saveEventLog);
        }
        catch (Exception e) {
            String message = ExceptionUtils.getMessage((Throwable)e);
            log.error((Object)("[LmcUtil] " + message), (Throwable)e);
        }
    }

    public static void callbackRtnEventOnNot200(Header[] header, String body, Map<String, Object> requestHeader, long timestamp, int httpStatus) {
        try {
            SaveEventLog saveEventLog = LmcUtil.getSaveEventLog("callbackRtn");
            saveEventLog.setStatus(Integer.valueOf(0));
            Map<String, Object> requestHeaderMap = LmcUtil.convertMap(requestHeader);
            Map<String, Object> headerMap = LmcUtil.headerArrayToMap(header);
            HashMap<String, Object> content = new HashMap<String, Object>();
            content.put("requestHeader", requestHeaderMap);
            content.put("timestamp", timestamp);
            content.put("httpStatus", httpStatus);
            content.put("header", headerMap);
            if (LmcUtil.isStringValidJson(body)) {
                Map bodyMap = (Map)JsonUtils.readValue((String)body, (TypeReference)new TypeReference<Map<String, Object>>(){});
                content.put("body", bodyMap);
            } else {
                content.put("body", body);
            }
            saveEventLog.setContent(content);
            LmcUtil.saveEventLog(saveEventLog);
        }
        catch (Exception e) {
            String message = ExceptionUtils.getMessage((Throwable)e);
            log.error((Object)("[LmcUtil] " + message), (Throwable)e);
        }
    }

    private static SaveEventLog getSaveEventLog(String event) {
        ProfileProvider profileProvider = (ProfileProvider)SpringContextUtils.getBean(ProfileProvider.class);
        Map<String, Object> profile = profileProvider.get();
        if (profile == null) {
            profile = new HashMap<String, Object>();
        }
        String tenantId = String.valueOf(profile.getOrDefault("tenantId", ""));
        SaveEventLog saveEventLog = new SaveEventLog();
        saveEventLog.setEventId(event);
        saveEventLog.setEventName(event);
        saveEventLog.setEventType(Integer.valueOf(0));
        saveEventLog.setTenantId(tenantId);
        return saveEventLog;
    }

    private static void saveEventLog(SaveEventLog saveEventLog) throws Exception {
        LmcUtil.initLmcClient();
        LMCCLIENT_INSTANCE.saveEventLog(saveEventLog);
    }

    private static boolean isStringValidJson(String s) {
        try {
            new JSONObject(s);
        }
        catch (JSONException e) {
            try {
                new JSONArray(s);
            }
            catch (JSONException e1) {
                return false;
            }
        }
        return true;
    }

    private static Map<String, Object> headerArrayToMap(Header[] header) {
        HashMap<String, Object> headerMap = new HashMap<String, Object>();
        List<Header> headers = Arrays.asList(header);
        for (Header element : headers) {
            String key = element.getName();
            String value = element.getValue();
            if (LmcUtil.isStringValidJson(value)) {
                Map valueMap = (Map)JsonUtils.readValue((String)value, (TypeReference)new TypeReference<Map<String, Object>>(){});
                headerMap.put(key, valueMap);
                continue;
            }
            headerMap.put(key, value);
        }
        return headerMap;
    }

    private static Map<String, Object> convertMap(Map<String, Object> header) {
        HashMap<String, Object> headerMap = new HashMap<String, Object>();
        Set<String> keySet = header.keySet();
        for (String key : keySet) {
            Object value = header.get(key);
            String valueString = String.valueOf(value);
            if (LmcUtil.isStringValidJson(valueString = valueString.replaceAll("\\\\\"", "\""))) {
                Map valueMap = (Map)JsonUtils.readValue((String)valueString, (TypeReference)new TypeReference<Map<String, Object>>(){});
                headerMap.put(key, valueMap);
                continue;
            }
            headerMap.put(key, value);
        }
        return headerMap;
    }

    public static void initLmcClient() {
        if (LMCCLIENT_INSTANCE == null) {
            ConfigProvider configProvider = (ConfigProvider)SpringContextUtils.getBean(ProfileProvider.class);
            String lmcUrl = configProvider.getLmcUrl();
            String appToken = configProvider.getIamApToken();
            String appSecret = null;
            LMCCLIENT_INSTANCE = new LMCClient(lmcUrl, "esp", appToken, appSecret);
        }
    }
}

