/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.http.client;

import com.digiwin.http.client.DWHttpRetryManager;
import com.digiwin.http.client.exception.DWHttpRetryIOException;
import com.digiwin.http.context.DWHttpRetryInfo;
import java.io.IOException;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.protocol.HttpContext;

public class DWHttpResponseInterceptor
implements HttpResponseInterceptor {
    private DWHttpRetryManager retryManager;

    public DWHttpResponseInterceptor() {
    }

    public DWHttpResponseInterceptor(DWHttpRetryManager retryManager) {
        this.retryManager = retryManager;
    }

    private DWHttpRetryManager getRetryManager() {
        return this.retryManager == null ? DWHttpRetryManager.getInstance() : this.retryManager;
    }

    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        DWHttpRetryInfo retryInfo = this.getRetryManager().getRetryInfo(context);
        if (retryInfo == null || !retryInfo.canRetry()) {
            return;
        }
        int status = response.getStatusLine().getStatusCode();
        if (status == 200) {
            if (retryInfo.matchSuccessResponseBodyKeywords(response)) {
                throw new DWHttpRetryIOException(retryInfo, String.format("status=200, retry key words: %s", retryInfo.getSourceRetryDefinition().getBodyKeywords()));
            }
        } else if (retryInfo.matchResponseStatusCode(response)) {
            throw new DWHttpRetryIOException(retryInfo, String.format("status=%s, retry status code: %s", response.getStatusLine().getStatusCode(), retryInfo.getSourceRetryDefinition().getStatuses()));
        }
    }
}

