/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.http.client.config.apollo;

import com.ctrip.framework.apollo.Config;
import com.ctrip.framework.apollo.ConfigService;
import com.digiwin.http.client.DWHttpTargetEAIServiceInfo;
import com.digiwin.http.client.config.DWHttpAPIInfoProvider;
import com.digiwin.http.client.config.mdc.MDCUtil;
import com.digiwin.http.client.utils.DWPathPatternHelper;
import com.digiwin.http.context.DWHttpContextUtils;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpRequest;
import org.apache.http.protocol.HttpContext;

public class DWApolloHttpAPIInfoProvider
implements DWHttpAPIInfoProvider {
    private static Log log = LogFactory.getLog(DWApolloHttpAPIInfoProvider.class);
    private static final String NAMESPACE_FORMAT_APP_EAI_API_IDEMPOTENCE = "%s_ei";
    private static final String NAMESPACE_FORMAT_APP_GENERAL_API_IDEMPOTENCE = "%s_ai";
    private static final String NAMESPACE_FORMAT_GLOBAL_EAI_API_IDEMPOTENCE = "global_ei_%s";

    public DWApolloHttpAPIInfoProvider(String mdcUrl) {
        MDCUtil.setMDCUrl(mdcUrl);
    }

    public boolean handleAsIdempotent(HttpContext httpContext) {
        Boolean isIdempotence = DWHttpContextUtils.isIdempotence((HttpContext)httpContext);
        if (isIdempotence == null) {
            log.debug((Object)"DWApolloHttpAPIInfoProvider.handleAsIdempotent, ready to retrieve API idempotence...");
            Boolean isEAIService = DWHttpContextUtils.isEAIService((HttpContext)httpContext);
            if (Boolean.TRUE.equals(isEAIService)) {
                DWHttpTargetEAIServiceInfo targetEAIServiceInfo = DWHttpContextUtils.getEAIServiceInfo((HttpContext)httpContext);
                if (targetEAIServiceInfo == null) {
                    log.warn((Object)"DWApolloHttpAPIInfoProvider.handleAsIdempotent, can not get eai service info!");
                    return false;
                }
                isIdempotence = this.isEAIAPIIdempotent(httpContext, targetEAIServiceInfo);
            } else {
                HttpRequest httpRequest = DWHttpContextUtils.getRequest((HttpContext)httpContext);
                String appId = DWHttpContextUtils.getAppId((HttpContext)httpContext);
                if (appId == null) {
                    appId = DWHttpContextUtils.getHost((HttpContext)httpContext);
                }
                String servicePath = DWHttpContextUtils.getServicePath((HttpContext)httpContext);
                isIdempotence = this.isGeneralAPIIdempotent(httpContext, httpRequest, appId, servicePath);
            }
            DWHttpContextUtils.setIdempotence((HttpContext)httpContext, (boolean)isIdempotence);
        }
        return isIdempotence;
    }

    protected boolean isEAIAPIIdempotent(HttpContext httpContext, DWHttpTargetEAIServiceInfo targetEAIServiceInfo) {
        String serviceName = targetEAIServiceInfo.getServiceName();
        if (serviceName == null) {
            log.warn((Object)"DWApolloHttpAPIInfoProvider.handleAsIdempotent eai service name is null!");
            return false;
        }
        log.debug((Object)"DWApolloHttpAPIInfoProvider.isEAIAPIIdempotent ready to invoke MDC API to retrieve API idempotence.");
        return MDCUtil.getApiIdempotency(serviceName, targetEAIServiceInfo.getTenantId());
    }

    protected boolean isGeneralAPIIdempotent(HttpContext httpContext, HttpRequest request, String ownerAppId, String serviceUrl) {
        String[] supportMethods;
        if (ownerAppId == null) {
            return false;
        }
        String apiIdempotenceNamespace = String.format(NAMESPACE_FORMAT_APP_GENERAL_API_IDEMPOTENCE, ownerAppId);
        Config config = ConfigService.getConfig((String)apiIdempotenceNamespace);
        log.debug((Object)String.format("DWApolloHttpAPIInfoProvider.isGeneralAPIIdempotent get Apollo config(namespace=%s) size=%s", apiIdempotenceNamespace, config.getPropertyNames().size()));
        String value = this.searchMappingValue(config, serviceUrl);
        log.debug((Object)String.format("DWApolloHttpAPIInfoProvider.isGeneralAPIIdempotent API idempotence info(path=%s) value=%s", serviceUrl, value));
        if (value == null) {
            String[] uriParts;
            String lowerCaseServiceUrl = serviceUrl.toLowerCase();
            if ((value == null && lowerCaseServiceUrl.startsWith("/restful/service/") || lowerCaseServiceUrl.startsWith("/restful/standard/")) && (uriParts = serviceUrl.split("/")).length >= 3) {
                String string = uriParts[3];
                String sameDomainApiIdempotenceNamespace = String.format(NAMESPACE_FORMAT_APP_GENERAL_API_IDEMPOTENCE, string);
                config = ConfigService.getConfig((String)sameDomainApiIdempotenceNamespace);
                log.debug((Object)String.format("DWApolloHttpAPIInfoProvider.isGeneralAPIIdempotent get same domain rule - Apollo config(namespace=%s) size=%s", sameDomainApiIdempotenceNamespace, config.getPropertyNames().size()));
                value = this.searchMappingValue(config, serviceUrl);
                log.debug((Object)String.format("DWApolloHttpAPIInfoProvider.isGeneralAPIIdempotent API idempotence info(path=%s) value=%s", serviceUrl, value));
            }
        }
        if (value == null) {
            return false;
        }
        if (value.isEmpty()) {
            return true;
        }
        String[] detailInfoParts = value.toLowerCase().split("\\|");
        String methodInfo = null;
        for (String part : detailInfoParts) {
            if (!part.trim().startsWith("method=")) continue;
            methodInfo = part;
            break;
        }
        if (methodInfo == null) {
            return true;
        }
        String string = request.getRequestLine().getMethod();
        for (String supportMethod : supportMethods = methodInfo.substring("method=".length()).split(",")) {
            if (!string.equalsIgnoreCase(supportMethod)) continue;
            return true;
        }
        return false;
    }

    private String searchAntMappingValue(Config config, String serviceUrl) {
        Set propertyNames = config.getPropertyNames();
        Object contextPath = config.getProperty("@contextPath", "");
        if (!((String)contextPath).isEmpty()) {
            String lowerContextPath;
            String lowerServiceUrl;
            if (!((String)contextPath).startsWith("/")) {
                contextPath = "/" + (String)contextPath;
            }
            if ((lowerServiceUrl = serviceUrl.toLowerCase()).startsWith(lowerContextPath = ((String)contextPath).toLowerCase())) {
                serviceUrl = serviceUrl.substring(((String)contextPath).length());
            }
        }
        for (String antKey : propertyNames) {
            String matchedResult = DWPathPatternHelper.getMatchingPattern((String)antKey, (String)serviceUrl);
            if (matchedResult == null) continue;
            return config.getProperty(matchedResult, serviceUrl);
        }
        return null;
    }

    private String searchMappingValue(Config config, String serviceUrl) {
        return this.searchAntMappingValue(config, serviceUrl);
    }
}

