/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.http.serializer;

import com.digiwin.http.client.condition.DWHttpRetryCondition;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;

public class DWHttpRetryConditionDeserializer
implements JsonDeserializer<DWHttpRetryCondition> {
    private static final String KEY_FIELD = "type";
    private static Map<String, Class<? extends DWHttpRetryCondition>> matcherTypes = new TreeMap<String, Class<? extends DWHttpRetryCondition>>(String.CASE_INSENSITIVE_ORDER);

    public static synchronized <T extends DWHttpRetryCondition> void register(Class<T> matcherClass) {
        Objects.requireNonNull(matcherClass);
        if (matcherClass.isInterface()) {
            throw new IllegalArgumentException("matcherType can not be interface");
        }
        String aliasName = DWHttpRetryCondition.getAlias(matcherClass);
        matcherTypes.put(aliasName, matcherClass);
    }

    public DWHttpRetryCondition deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        boolean hasName = jsonObject.has(KEY_FIELD);
        String typeName = "";
        if (hasName) {
            typeName = jsonObject.get(KEY_FIELD).getAsString().toLowerCase();
            Class<? extends DWHttpRetryCondition> matcherType = matcherTypes.get(typeName);
            if (matcherType == null) {
                matcherType = this.searchConditionByClassName(typeName);
            }
            if (matcherType != null) {
                return (DWHttpRetryCondition)jsonDeserializationContext.deserialize((JsonElement)jsonObject, matcherType);
            }
        }
        throw new IllegalArgumentException(String.format("DWHttpRetryCondition element has no field: %s, or field value: %s can not find mapping condition!", KEY_FIELD, typeName));
    }

    private Class<? extends DWHttpRetryCondition> searchConditionByClassName(String type) {
        Class targetClass = matcherTypes.values().stream().filter(c -> c.getName().equalsIgnoreCase(type)).findFirst().orElse(null);
        if (targetClass == null) {
            targetClass = matcherTypes.values().stream().filter(c -> c.getSimpleName().equalsIgnoreCase(type)).findFirst().orElse(null);
        }
        return targetClass;
    }
}

