/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.iam;

import com.dap.component.iam.api.DapIamUserService;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.app.service.DWServiceResult;
import com.digiwin.app.service.restful.DWRequestMethod;
import com.digiwin.iam.DWIAMProperties;
import com.digiwin.iam.HttpResponseModel;
import com.digiwin.iam.IAMService;
import com.digiwin.iam.ServiceModel;
import java.util.HashMap;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;

public class IAMUserService
implements DapIamUserService {
    @Autowired
    private DWIAMProperties properties;
    private static String APP_ID;
    private static String API_PATH_USER_TENANT_APPLICATION;

    public static void setAppId(String appId) {
        APP_ID = appId;
    }

    public static void setApiPathUserTenantApplicaiton(String apiPathUserTenantApplication) {
        API_PATH_USER_TENANT_APPLICATION = apiPathUserTenantApplication;
    }

    @Override
    public DWServiceResult getSecretKey() throws Exception {
        String token = Objects.toString(DWServiceContext.getContext().getRequestHeader().get("token"));
        if (Objects.isNull(token)) {
            token = Objects.toString(DWServiceContext.getContext().getRequestHeader().get("digi-middleware-auth-user"));
        }
        if (this.properties != null) {
            return this.getSecretKey(this.properties.getAppId(), token);
        }
        return this.getSecretKey(APP_ID, token);
    }

    @Override
    public DWServiceResult getSecretKey(String appId, String token) throws Exception {
        DWServiceResult result = new DWServiceResult();
        boolean success = false;
        boolean isException = false;
        boolean foundAppId = false;
        boolean foundSecretKey = false;
        String message = "";
        String secretKey = "";
        try {
            HttpResponseModel iamResponse = this.getTenantApplication(appId, token);
            JSONArray applicationArray = new JSONArray(iamResponse.getResponseBody());
            for (int j = 0; j < applicationArray.length(); ++j) {
                JSONObject application = applicationArray.getJSONObject(j);
                if (!appId.equals(application.getString("id"))) continue;
                foundAppId = true;
                if (!application.has("secretKey")) continue;
                foundSecretKey = true;
                secretKey = application.getString("secretKey");
                break;
            }
        }
        catch (Exception e) {
            isException = true;
            message = e.getMessage();
        }
        if (!isException) {
            if (!foundAppId) {
                message = String.format("App id %s not found", appId);
            } else if (!foundSecretKey) {
                message = String.format("App id %s secret key not found", appId);
            } else {
                success = true;
                message = String.format("App id %s secret key found", appId);
            }
        }
        result.setSuccess((Object)success);
        result.setData((Object)secretKey);
        result.setMessage(message);
        return result;
    }

    @Override
    public HttpResponseModel getTenantApplication() throws Exception {
        String token = Objects.toString(DWServiceContext.getContext().getRequestHeader().get("token"));
        if (Objects.isNull(token)) {
            token = Objects.toString(DWServiceContext.getContext().getRequestHeader().get("digi-middleware-auth-user"));
        }
        String appId = null;
        appId = this.properties != null ? this.properties.getAppId() : APP_ID;
        return this.getTenantApplication(appId, token);
    }

    @Override
    public HttpResponseModel getTenantApplication(String appId, String token) throws Exception {
        ServiceModel serviceModel = new ServiceModel();
        String invokeURL = null;
        invokeURL = this.properties != null ? this.properties.getApiPathUserTenantApplication() : API_PATH_USER_TENANT_APPLICATION;
        serviceModel.setInvokeURL(invokeURL);
        serviceModel.setParams(new HashMap<String, Object>());
        serviceModel.setRequestMethod(DWRequestMethod.GET);
        if (StringUtils.isNotBlank((CharSequence)token)) {
            serviceModel.setToken(token);
        }
        return (HttpResponseModel)IAMService.invoke(serviceModel);
    }
}

