/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.iam;

import com.dap.component.iam.api.DapUserTokenService;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.iam.DWIAMProperties;
import com.digiwin.iam.HttpResponseModel;
import com.digiwin.iam.IAMCommonService;
import com.digiwin.iam.IAMService;
import com.digiwin.iam.ServiceModel;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;

public class UserTokenService
implements DapUserTokenService {
    @Autowired
    IAMCommonService iamCommonService;
    @Autowired
    private DWIAMProperties properties;
    @Autowired
    Environment env;

    @Override
    public HttpResponseModel verifyToken(String token) throws Exception {
        return this.verifyToken(token, false);
    }

    @Override
    public HttpResponseModel verifyToken(String token, boolean apiPermissionEnable) throws Exception {
        if (StringUtils.isEmpty((CharSequence)token)) {
            throw new DWBusinessException("userToken \u4e0d\u53ef\u70ba\u7a7a");
        }
        Object url = this.properties.getApiPathUserTokenAnalyze();
        if (apiPermissionEnable) {
            url = (String)url + "?ramVersion=v2";
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        return this.iamCommonService.invokeIAMWithDWHttpClient((String)url, params, token);
    }

    @Override
    public HttpResponseModel exchangeToken(String token, String tenantId) throws Exception {
        if (StringUtils.isEmpty((CharSequence)tenantId)) {
            throw new DWBusinessException("tenantId \u4e0d\u53ef\u70ba\u7a7a");
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("tenantId", tenantId);
        params.put("userId", this.properties.getIntegrationUserId());
        params.put("passwordHash", this.properties.getIntegrationUserPasswordHash());
        return this.iamCommonService.invokeIAMWithDWHttpClient(this.properties.getApiPathIntegrationUserLogin(), params, token);
    }

    @Override
    @Deprecated
    public HttpResponseModel verifyTokenWithoutCache(String token) throws Exception {
        return this.verifyTokenCommon(token);
    }

    @Override
    @Deprecated
    public HttpResponseModel verifyTokenCommon(String token) throws Exception {
        if (StringUtils.isEmpty((CharSequence)token)) {
            throw new DWBusinessException("userToken \u4e0d\u53ef\u70ba\u7a7a");
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        return this.iamCommonService.invokeIAMWithDWHttpClient(this.properties.getApiPathUserTokenAnalyze(), params, token);
    }

    @Deprecated
    public static Object invokeIAM(String invokeURL, Map<String, Object> params, String token) throws Exception {
        ServiceModel serviceModel = new ServiceModel();
        serviceModel.setInvokeURL(invokeURL);
        serviceModel.setParams(params);
        serviceModel.setToken(token);
        return IAMService.invoke(serviceModel);
    }
}

