/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.autoconfigure.iam;

import com.dap.component.iam.api.DapIamCommonService;
import com.dap.component.iam.api.DapIamFuncPermissionService;
import com.dap.component.iam.api.DapIamIdentityService;
import com.dap.component.iam.api.DapIamUserAllInfoService;
import com.dap.component.iam.api.DapIamUserInfoService;
import com.dap.component.iam.api.DapIamUserService;
import com.dap.component.iam.api.DapUserTokenService;
import com.digiwin.iam.DWIAMProperties;
import com.digiwin.iam.IAMCommonService;
import com.digiwin.iam.IAMFuncPermissionService;
import com.digiwin.iam.IAMHttpRequester;
import com.digiwin.iam.IAMIdentityService;
import com.digiwin.iam.IAMUserAllInfoService;
import com.digiwin.iam.IAMUserInfoService;
import com.digiwin.iam.IAMUserService;
import com.digiwin.iam.UserTokenService;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.core.env.Environment;

@DependsOn(value={"dw-spring-context-utils"})
@Configuration
@ConditionalOnClass(value={IAMHttpRequester.class})
@AutoConfigureOrder(value=-2147483648)
public class DWIAMAutoConfiguration {
    @Bean(value={"dw-iam-properties"})
    public DWIAMProperties getProperties(Environment environment) {
        DWIAMProperties properties = new DWIAMProperties();
        properties.setUrl(environment.getProperty("iamUrl"));
        properties.setContentType(environment.getProperty("iamContentType"));
        properties.setCharset(environment.getProperty("iamCharset"));
        properties.setConnectionRequestTimeout(Integer.parseInt(environment.getProperty("iamHttpConnectionPoolRequestTimeout")));
        properties.setConnectionTimeout(Integer.parseInt(environment.getProperty("iamHttpConnectionTimeout")));
        properties.setRequestSocketTimeout(Integer.parseInt(environment.getProperty("iamSoTimeout")));
        properties.setEncode(environment.getProperty("iamEncode"));
        properties.setConnectionMaxTotal(Integer.parseInt(environment.getProperty("iamHttpMaxConnections")));
        properties.setKeepAliveTimeout(Long.parseLong(environment.getProperty("iamKeepAliveTimeout")));
        String evictExpiredConnectionsString = environment.getProperty("iamHttpEvictExpiredConnections");
        properties.setEvictExpiredConnections(Boolean.parseBoolean(evictExpiredConnectionsString));
        String evictIdleConnectionsMaxIdleTimeString = environment.getProperty("iamHttpEvictIdleConnectionsMaxIdleTime");
        if (evictIdleConnectionsMaxIdleTimeString != null) {
            properties.setEvictIdleConnectionsMaxIdleTime(Long.valueOf(Long.parseLong(evictIdleConnectionsMaxIdleTimeString)));
        }
        properties.setAppToken(environment.getProperty("iamApToken", ""));
        properties.setAppSecret(environment.getProperty("iamApSecret", ""));
        properties.setAppAuthEnabled(Boolean.parseBoolean(environment.getProperty("dap.app-auth.enabled")));
        properties.setAppAuthExcludeAnonymousApi(Boolean.parseBoolean(environment.getProperty("dap.app-auth.exclude-anonymous-api")));
        properties.setAppAuthExcludeEAICallback(Boolean.parseBoolean(environment.getProperty("dap.app-auth.exclude-eai-callback")));
        String excludeUri = environment.getProperty("dap.app-auth.exclude", "");
        if (excludeUri.length() > 0) {
            List<String> excludeList = Arrays.asList(excludeUri.split(","));
            properties.setAppAuthExcludeURIs(excludeList.stream().map(String::trim).collect(Collectors.toSet()));
        }
        String serverTokenMode = environment.getProperty("serverHttpTokenmode", "");
        properties.setIAMTokenMode(serverTokenMode.equals("IAM"));
        properties.setApiPathUserBasicInfo(environment.getProperty("iamUrlUser"));
        properties.setApiPathLogin(environment.getProperty("iamUrlLogin"));
        properties.setApiPathUserTokenAnalyze(environment.getProperty("iamUrlUsertokenAnalyze"));
        properties.setApiPathUserAllInfo(environment.getProperty("iamUrlUserAllInfo"));
        properties.setApiPathUserTenantApplication(environment.getProperty("iamUrlUserTenantApplication"));
        properties.setApiPathIntegrationUserLogin(environment.getProperty("iamUrlIntegrationUserLogin", "/api/iam/v2/identity/login/internal"));
        properties.setIntegrationUserId(environment.getProperty("iamIntegrationUserId", "integration"));
        properties.setIntegrationUserPasswordHash(environment.getProperty("iamIntegrationUserPasswordHash", "6826CC688C4AF1BD0A8DDA2DBDF8897B"));
        Set tokenNames = Arrays.stream(environment.getProperty("dap.user-auth.token-names", "token,digi-middleware-auth-user").split(",")).collect(Collectors.toSet());
        properties.setTokenNames(tokenNames);
        String profileExtraFieldsString = environment.getProperty("dap.user-auth.profile-extra-fields");
        if (profileExtraFieldsString == null || profileExtraFieldsString.isEmpty()) {
            properties.setProfileExtraFields(Collections.emptySet());
        } else {
            properties.setProfileExtraFields(Arrays.stream(profileExtraFieldsString.split(",")).collect(Collectors.toSet()));
        }
        String exchangeIntegrationToken = environment.getProperty("dap.user-auth.exchange-integration-token", "true");
        properties.setExchangeIntegrationToken(Boolean.parseBoolean(exchangeIntegrationToken));
        IAMHttpRequester.setProperties((DWIAMProperties)properties);
        return properties;
    }

    @Configuration
    @DependsOn(value={"dw-iam-properties"})
    static class DWIAMServiceConfiguration {
        DWIAMServiceConfiguration() {
        }

        @Bean(name={"dwUserTokenService"})
        public UserTokenService userTokenService() {
            return new UserTokenService();
        }

        @Bean(name={"dapUserTokenService"})
        public DapUserTokenService dapUserTokenService() {
            return new UserTokenService();
        }

        @Bean(name={"dwIAMFuncPermissionService"})
        public IAMFuncPermissionService funcPermissionService() {
            return new IAMFuncPermissionService();
        }

        @Bean(name={"dapIamFuncPermissionService"})
        public DapIamFuncPermissionService dapIamFuncPermissionService() {
            return new IAMFuncPermissionService();
        }

        @Bean(name={"dwIAMUserService"})
        public IAMUserService userService(DWIAMProperties dwIamProperties) {
            IAMUserService iamUserService = new IAMUserService();
            IAMUserService.setAppId((String)dwIamProperties.getAppId());
            IAMUserService.setApiPathUserTenantApplicaiton((String)dwIamProperties.getApiPathUserTenantApplication());
            return iamUserService;
        }

        @Bean(name={"dapIamUserService"})
        public DapIamUserService dapIamUserService(DWIAMProperties dwIamProperties) {
            IAMUserService iamUserService = new IAMUserService();
            IAMUserService.setAppId((String)dwIamProperties.getAppId());
            IAMUserService.setApiPathUserTenantApplicaiton((String)dwIamProperties.getApiPathUserTenantApplication());
            return iamUserService;
        }

        @Bean(name={"dwIAMIdentityService"})
        public IAMIdentityService identityService() {
            return new IAMIdentityService();
        }

        @Bean(name={"dapIamIdentityService"})
        public DapIamIdentityService dapIamIdentityService() {
            return new IAMIdentityService();
        }

        @Bean(name={"dwIAMCommonService"})
        public IAMCommonService iamCommonService() {
            return new IAMCommonService();
        }

        @Bean(name={"dapIamCommonService"})
        public DapIamCommonService dapIamCommonService() {
            return new IAMCommonService();
        }

        @Bean(name={"dwIAMUserInfoService"})
        public IAMUserInfoService userInfoService() {
            return new IAMUserInfoService();
        }

        @Bean(name={"dapIamUserInfoService"})
        public DapIamUserInfoService dapIamUserInfoService() {
            return new IAMUserInfoService();
        }

        @Bean(name={"dwIAMUserAllInfoService"})
        public IAMUserAllInfoService userAllInfoService() {
            return new IAMUserAllInfoService();
        }

        @Bean(name={"dapIamUserAllInfoService"})
        public DapIamUserAllInfoService dapIamUserAllInfoService() {
            return new IAMUserAllInfoService();
        }
    }
}

