/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.json.gson;

import com.dap.component.json.api.ConfigProvider;
import com.digiwin.app.json.gson.DWGsonProvider;
import com.digiwin.app.json.gson.serializer.DWJsonViewFieldFilterMapSerializer;
import com.digiwin.app.json.strategy.DWViewFieldFilter;
import com.digiwin.app.json.strategy.DWViewFieldFilterStrategy;
import com.digiwin.app.module.spring.SpringContextUtils;
import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Map;

public final class DWJsonViewGsonProvider {
    private DWJsonViewGsonProvider() {
    }

    private static Gson getFieldFilterGson() {
        GsonBuilder builder = DWGsonProvider.getGsonBuilder();
        builder.addSerializationExclusionStrategy((ExclusionStrategy)new DWViewFieldFilterStrategy());
        builder.registerTypeHierarchyAdapter(Map.class, (Object)new DWJsonViewFieldFilterMapSerializer());
        return builder.create();
    }

    public static void initCurrentViewInfo(Method method) {
        ConfigProvider configProvider = (ConfigProvider)SpringContextUtils.getBean(ConfigProvider.class);
        configProvider.setContextDataKeyTargetSourceMethod(DWViewFieldFilter.CONTEXT_DATA_KEY_TARGET_SOURCE_METHOD, method);
    }

    private static Gson getCurrentViewGson() {
        boolean hasViewFilter = DWViewFieldFilter.updateCurrentViewFilterContextData();
        if (hasViewFilter) {
            return DWJsonViewGsonProvider.getFieldFilterGson();
        }
        return DWGsonProvider.getGson();
    }

    public static String toJson(Object src) {
        try {
            Gson gson = DWJsonViewGsonProvider.getCurrentViewGson();
            String string = gson.toJson(src);
            return string;
        }
        finally {
            DWViewFieldFilter.clearCurrentViewFilterContextData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toJson(Object src, Type typeOfSrc) {
        try {
            Gson gson = DWJsonViewGsonProvider.getCurrentViewGson();
            String string = gson.toJson(src, typeOfSrc);
            return string;
        }
        finally {
            DWViewFieldFilter.clearCurrentViewFilterContextData();
        }
    }
}

