/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.json.gson.adapter;

import com.dap.component.json.api.ConfigProvider;
import com.digiwin.app.json.DWJsonConfig;
import com.digiwin.app.json.gson.DWGsonProvider;
import com.digiwin.app.json.processor.number.DWNumberProcessor;
import com.digiwin.app.module.spring.SpringContextUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonSerializer;
import com.google.gson.TypeAdapter;
import com.google.gson.internal.LinkedTreeMap;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;

public class DWObjectTypeAdapter
extends TypeAdapter<Object> {
    private DWNumberProcessor numberProcessor;

    public DWObjectTypeAdapter(DWNumberProcessor numberProcessor) {
        this.numberProcessor = numberProcessor;
    }

    public void write(JsonWriter out, Object value) throws IOException {
        GsonBuilder builder = new GsonBuilder();
        ConfigProvider configProvider = (ConfigProvider)SpringContextUtils.getBean(ConfigProvider.class);
        String dateFormatPattern = configProvider.getDeserializationDateFormat("dap.json.deserialization.dateformat", DWJsonConfig.getDateTimeFormat());
        builder.setDateFormat(dateFormatPattern);
        if (DWJsonConfig.getSerializeNull().booleanValue()) {
            builder.serializeNulls();
        }
        builder.disableHtmlEscaping();
        this.registerAdapter(builder);
        Gson gson = builder.create();
        if (null != value) {
            Class<?> clazz = value.getClass();
            gson.getAdapter(clazz).write(out, value);
        } else {
            gson.getAdapter(Object.class).write(out, null);
        }
    }

    private void registerAdapter(GsonBuilder builder) {
        int i;
        for (i = 0; i < DWGsonProvider.getTypeList().size(); ++i) {
            Object adapter = DWGsonProvider.getAdapterList().get(i);
            if (!(adapter instanceof JsonSerializer) && !(adapter instanceof JsonDeserializer)) continue;
            builder.registerTypeAdapter((Type)DWGsonProvider.getTypeList().get(i), adapter);
        }
        for (i = 0; i < DWGsonProvider.getTypeTokenList().size(); ++i) {
            Object tokenAdapter = DWGsonProvider.getTypeTokenAdapterList().get(i);
            if (!(tokenAdapter instanceof JsonSerializer) && !(tokenAdapter instanceof JsonDeserializer)) continue;
            builder.registerTypeAdapter(DWGsonProvider.getTypeTokenList().get(i).getType(), tokenAdapter);
        }
    }

    public Object read(JsonReader in) throws IOException {
        JsonToken token = in.peek();
        switch (token) {
            case BEGIN_ARRAY: {
                ArrayList<Object> list = new ArrayList<Object>();
                in.beginArray();
                while (in.hasNext()) {
                    list.add(this.read(in));
                }
                in.endArray();
                return list;
            }
            case BEGIN_OBJECT: {
                LinkedTreeMap map = new LinkedTreeMap();
                in.beginObject();
                while (in.hasNext()) {
                    map.put(in.nextName(), this.read(in));
                }
                in.endObject();
                return map;
            }
            case STRING: {
                return in.nextString();
            }
            case NUMBER: {
                String val = in.nextString();
                return this.numberProcessor.process(val);
            }
            case BOOLEAN: {
                return in.nextBoolean();
            }
            case NULL: {
                in.nextNull();
                return null;
            }
        }
        throw new IllegalStateException();
    }
}

