/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.json.strategy;

import com.dap.component.json.api.ConfigProvider;
import com.dap.component.json.api.RequestHeaderProvider;
import com.digiwin.app.container.exceptions.DWRuntimeException;
import com.digiwin.app.module.spring.SpringContextUtils;
import com.digiwin.app.service.view.DWViewConfig;
import com.digiwin.app.service.view.DWViewConfigs;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;

public class DWViewFieldFilter {
    public static String HEADER_KEY_DIGI_JSON_VIEW = "digi-json-view";
    public static String CONTEXT_DATA_KEY_TARGET_SOURCE_METHOD = "targetSourceMethod";
    private static String CONTEXT_DATA_KEY_CURRENT_VIEW_FILTER = "digi-json-view-field-filter";
    private String viewName;
    private String[] include;
    private String[] exclude;

    private DWViewFieldFilter(DWViewConfig configuration) {
        this.viewName = configuration.name();
        this.include = configuration.include();
        this.exclude = configuration.exclude();
    }

    public boolean shouldFilter(String fieldName) {
        if (this.include.length > 0) {
            for (String includeKey : this.include) {
                if (!includeKey.equalsIgnoreCase(fieldName)) continue;
                return false;
            }
            return true;
        }
        for (String excludeKey : this.exclude) {
            if (!excludeKey.equalsIgnoreCase(fieldName)) continue;
            return true;
        }
        return false;
    }

    public Map filter(Map source) {
        if (source.isEmpty()) {
            return source;
        }
        LinkedHashMap filterMap = new LinkedHashMap();
        for (Object key : source.keySet()) {
            for (String excludeKey : this.exclude) {
                if (excludeKey.equalsIgnoreCase(key.toString())) continue;
                filterMap.put((String)key, source.get(key));
            }
        }
        return filterMap;
    }

    public static DWViewFieldFilter getFromServiceContext() {
        ConfigProvider configProvider = (ConfigProvider)SpringContextUtils.getBean(ConfigProvider.class);
        return configProvider.getContextDataKeyCurrentViewFilter(CONTEXT_DATA_KEY_CURRENT_VIEW_FILTER);
    }

    private static DWViewFieldFilter createIfNeeded() {
        ConfigProvider configProvider;
        Method method;
        RequestHeaderProvider requestHeaderProvider = (RequestHeaderProvider)SpringContextUtils.getBean(RequestHeaderProvider.class);
        Map<String, Object> requestHeader = requestHeaderProvider.get();
        if (requestHeader.containsKey(HEADER_KEY_DIGI_JSON_VIEW) && (method = (configProvider = (ConfigProvider)SpringContextUtils.getBean(ConfigProvider.class)).getContextDataKeyTargetSourceMethod(CONTEXT_DATA_KEY_TARGET_SOURCE_METHOD)) != null) {
            String viewName = (String)requestHeader.get(HEADER_KEY_DIGI_JSON_VIEW);
            if (viewName == null) {
                return null;
            }
            DWViewConfig[] configurationArray = null;
            if (method.isAnnotationPresent(DWViewConfig.class)) {
                configurationArray = new DWViewConfig[]{method.getAnnotation(DWViewConfig.class)};
            } else if (method.isAnnotationPresent(DWViewConfigs.class)) {
                DWViewConfigs configurations = method.getAnnotation(DWViewConfigs.class);
                configurationArray = configurations.value();
            }
            DWViewConfig targetViewConfiguration = null;
            if (configurationArray != null) {
                for (DWViewConfig configuration : configurationArray) {
                    if (!viewName.equalsIgnoreCase(configuration.name())) continue;
                    targetViewConfiguration = configuration;
                    break;
                }
            }
            return DWViewFieldFilter.createFilter(method, targetViewConfiguration);
        }
        return null;
    }

    private static DWViewFieldFilter createFilter(Method method, DWViewConfig viewConfig) {
        if (viewConfig == null) {
            return null;
        }
        if (viewConfig.include().length != 0 && viewConfig.exclude().length != 0) {
            throw new DWRuntimeException(String.format("Method(name=%s) DWViewConfig(name=%s) setting both the include and exclude properties is not allowed.", method.getName(), viewConfig.name()));
        }
        return new DWViewFieldFilter(viewConfig);
    }

    public static boolean updateCurrentViewFilterContextData() {
        DWViewFieldFilter fieldFilter = DWViewFieldFilter.createIfNeeded();
        ConfigProvider configProvider = (ConfigProvider)SpringContextUtils.getBean(ConfigProvider.class);
        configProvider.setContextDataKeyCurrentViewFilter(CONTEXT_DATA_KEY_CURRENT_VIEW_FILTER, fieldFilter);
        return fieldFilter != null;
    }

    public static boolean clearCurrentViewFilterContextData() {
        ConfigProvider configProvider = (ConfigProvider)SpringContextUtils.getBean(ConfigProvider.class);
        return configProvider.removeContextDataKeyCurrentViewFilter(CONTEXT_DATA_KEY_CURRENT_VIEW_FILTER) != null;
    }
}

