/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.loadbalance.scan;

import com.digiwin.loadbalance.scan.candidate.DWResourceHelper;
import com.digiwin.loadbalance.scan.candidate.DWTargetResource;
import com.digiwin.loadbalance.scan.candidate.VersionApiCandidate;
import com.digiwin.loadbalance.scan.metadata.ApiMetadata;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.env.Environment;
import org.springframework.util.CollectionUtils;

public class DWCommonScanner {
    private Log log = LogFactory.getLog(DWCommonScanner.class);
    List<VersionApiCandidate> apiCandidates;

    public DWCommonScanner(Environment environment, List<VersionApiCandidate> apiCandidates, DWResourceHelper dwResourceHelper) {
        this.apiCandidates = apiCandidates;
    }

    public Set<ApiMetadata> scan(List<DWTargetResource> targetResourceList) throws Exception {
        if (CollectionUtils.isEmpty(this.apiCandidates)) {
            return new HashSet<ApiMetadata>();
        }
        HashSet<ApiMetadata> versionPathSet = new HashSet<ApiMetadata>();
        this.log.info((Object)("DWCommonScanner searchResultSize:" + targetResourceList.size()));
        for (VersionApiCandidate apiCandidate : this.apiCandidates) {
            versionPathSet.addAll(apiCandidate.resolver(targetResourceList));
        }
        return versionPathSet;
    }
}

