/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.loadbalance.scan.candidate;

import com.digiwin.app.service.DWService;
import com.digiwin.app.service.eai.EAICallback;
import com.digiwin.app.service.eai.EAIService;
import com.digiwin.loadbalance.scan.DWVersionable;
import com.digiwin.loadbalance.scan.candidate.AbstractVersionApiCandidate;
import com.digiwin.loadbalance.scan.metadata.ApiMetadata;
import com.digiwin.loadbalance.scan.metadata.EAIMetadata;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.type.classreading.MetadataReader;

public class DWEAIApiCandidate
extends AbstractVersionApiCandidate {
    private Log log = LogFactory.getLog(DWEAIApiCandidate.class);

    @Override
    public List<ApiMetadata> resolverPathRegex(MetadataReader classMetadataReader, String rootPath) {
        ArrayList<ApiMetadata> apiMetadataList = new ArrayList<ApiMetadata>();
        if (classMetadataReader.getClassMetadata().isInterface() && Arrays.stream(classMetadataReader.getClassMetadata().getInterfaceNames()).filter(interfaceName -> DWService.class.getName().equals(interfaceName)).findAny().isPresent()) {
            apiMetadataList.addAll(this.getEaiServiceId(classMetadataReader, EAIService.class, "id", classMetadataReader.getAnnotationMetadata().hasAnnotation(DWVersionable.class.getName())));
            apiMetadataList.addAll(this.getEaiServiceId(classMetadataReader, EAICallback.class, "id", classMetadataReader.getAnnotationMetadata().hasAnnotation(DWVersionable.class.getName())));
        }
        return apiMetadataList;
    }

    private List<ApiMetadata> getEaiServiceId(MetadataReader classMetadataReader, Class annotation, String attributeName, boolean versionAble) {
        return classMetadataReader.getAnnotationMetadata().getAnnotatedMethods(annotation.getName()).stream().map(methodMetadata -> new EAIMetadata(methodMetadata.getAnnotationAttributes(annotation.getName()).get(attributeName).toString(), methodMetadata.isAnnotated(DWVersionable.class.getName()) || versionAble)).collect(Collectors.toList());
    }
}

