/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.loadbalance.matcher;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.listener.NamingEvent;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.digiwin.loadbalance.matcher.DWMatcher;
import com.digiwin.loadbalance.watch.NacosServerListWatcher;
import com.google.gson.Gson;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.client.methods.HttpUriRequest;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Order(value=2147481647)
public class EAIMatcher
implements DWMatcher {
    private static Log log = LogFactory.getLog(EAIMatcher.class);
    private Gson gson = new Gson();
    private String eaiPath;
    private String eaiCallbackPath;
    AntPathMatcher antPathMatcher = new AntPathMatcher();
    NacosServerListWatcher nacosServerListWatcher;
    Environment environment;
    DiscoveryClient discoveryClient;

    private boolean pathMatche(String pattern, String path) {
        return this.antPathMatcher.match(pattern, path);
    }

    @Override
    public String prefix() {
        return "EAI";
    }

    public EAIMatcher(NacosServerListWatcher nacosServerListWatcher, Environment environment, DiscoveryClient discoveryClient) {
        this.nacosServerListWatcher = nacosServerListWatcher;
        this.environment = environment;
        this.discoveryClient = discoveryClient;
        String serviceName = environment.getProperty("loadbalancer.client.name");
        List instances = discoveryClient.getInstances(serviceName);
        if (!CollectionUtils.isEmpty((Collection)instances)) {
            ServiceInstance serviceInstance = (ServiceInstance)instances.get(0);
            String eaiRestfulPath = (String)serviceInstance.getMetadata().get("eai.restfulPath");
            String eaiRestfulCallbackPath = (String)serviceInstance.getMetadata().get("eai.callbackPath");
            this.eaiPath = eaiRestfulPath;
            this.eaiCallbackPath = eaiRestfulCallbackPath;
        }
        try {
            nacosServerListWatcher.watch(serviceName, event -> {
                List nameInstances;
                if (event instanceof NamingEvent && !CollectionUtils.isEmpty((Collection)(nameInstances = ((NamingEvent)event).getInstances()))) {
                    Instance instance = (Instance)nameInstances.get(0);
                    String eaiRestfulPath = (String)instance.getMetadata().get("eai.restfulPath");
                    String eaiRestfulCallbackPath = (String)instance.getMetadata().get("eai.callbackPath");
                    this.eaiPath = eaiRestfulPath;
                    this.eaiCallbackPath = eaiRestfulCallbackPath;
                }
            });
        }
        catch (NacosException e) {
            log.error((Object)("EAIMatcher watch service fail serviceName:" + serviceName), (Throwable)e);
        }
    }

    @Override
    public boolean canApply(HttpUriRequest request) {
        if (StringUtils.isEmpty((Object)this.eaiPath)) {
            return false;
        }
        Header firstHeader = request.getFirstHeader("digi-service");
        return null != firstHeader && StringUtils.hasText((String)firstHeader.getValue()) && (this.pathMatche(this.eaiPath, request.getURI().getPath()) || this.pathMatche(this.eaiCallbackPath, request.getURI().getPath()));
    }

    @Override
    public String getCacheKey(HttpUriRequest request) {
        Header firstHeader = request.getLastHeader("digi-service");
        Map map = (Map)this.gson.fromJson(firstHeader.getValue(), Map.class);
        return (String)map.get("name");
    }

    @Override
    public boolean match(String pattern, HttpUriRequest request) {
        String apiId = this.prefix() + "|" + this.getCacheKey(request);
        return apiId.equals(pattern);
    }
}

