/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.loadbalance.matcher.v2;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.listener.NamingEvent;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.digiwin.loadbalance.matcher.EAIMatcher;
import com.digiwin.loadbalance.matcher.v2.DWAbstractMatcherV2;
import com.digiwin.loadbalance.watch.NacosServerListWatcher;
import com.google.gson.Gson;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.client.methods.HttpUriRequest;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

@Order(value=2147481647)
public class EAIMatcherV2
extends DWAbstractMatcherV2 {
    private Gson gson = new Gson();
    AntPathMatcher antPathMatcher = new AntPathMatcher();
    private static Log log = LogFactory.getLog(EAIMatcher.class);
    private String eaiPath = null;
    private String eaiCallbackPath = null;
    NacosServerListWatcher nacosServerListWatcher;
    Environment environment;
    DiscoveryClient discoveryClient;

    public EAIMatcherV2(NacosServerListWatcher nacosServerListWatcher, Environment environment, DiscoveryClient discoveryClient) {
        this.nacosServerListWatcher = nacosServerListWatcher;
        this.environment = environment;
        this.discoveryClient = discoveryClient;
        String serviceName = environment.getProperty("loadbalancer.client.name");
        List instances = discoveryClient.getInstances(serviceName);
        if (!CollectionUtils.isEmpty((Collection)instances)) {
            ServiceInstance serviceInstance = (ServiceInstance)instances.get(0);
            String eaiRestfulPath = (String)serviceInstance.getMetadata().get("eai.restfulPath");
            String eaiRestfulCallbackPath = (String)serviceInstance.getMetadata().get("eai.callbackPath");
            this.eaiPath = eaiRestfulPath;
            this.eaiCallbackPath = eaiRestfulCallbackPath;
        }
        try {
            nacosServerListWatcher.watch(serviceName, event -> {
                List nameInstances;
                if (event instanceof NamingEvent && !CollectionUtils.isEmpty((Collection)(nameInstances = ((NamingEvent)event).getInstances()))) {
                    Instance instance = (Instance)nameInstances.get(0);
                    String eaiRestfulPath = (String)instance.getMetadata().get("eai.restfulPath");
                    String eaiRestfulCallbackPath = (String)instance.getMetadata().get("eai.callbackPath");
                    String contextPath = instance.getMetadata().getOrDefault("server_context_path", "");
                    UriComponents eaiUriComponents = UriComponentsBuilder.newInstance().path("/").path(contextPath).path("/").path(eaiRestfulPath).build();
                    UriComponents eaiCallbackUriComponents = UriComponentsBuilder.newInstance().path("/").path(contextPath).path("/").path(eaiRestfulCallbackPath).build();
                    this.eaiPath = eaiUriComponents.getPath();
                    this.eaiCallbackPath = eaiCallbackUriComponents.getPath();
                }
            });
        }
        catch (NacosException e) {
            log.error((Object)("EAIMatcher watch service fail serviceName:" + serviceName), (Throwable)e);
        }
    }

    @Override
    public boolean canApply(HttpUriRequest request) {
        if (StringUtils.isEmpty((Object)this.eaiPath)) {
            return false;
        }
        Header firstHeader = request.getFirstHeader("digi-service");
        return null != firstHeader && StringUtils.hasText((String)firstHeader.getValue()) && this.antPathMatcher.match(this.eaiPath, request.getURI().getPath());
    }

    @Override
    public String getCacheKey(HttpUriRequest request) {
        return this.getEaiIdInRequest(request);
    }

    @Override
    public boolean match(Map<String, String> instanceMetadata, HttpUriRequest request, boolean vesionAble) {
        String key;
        String targetEaiId = this.getEaiIdInRequest(request);
        int index = 0;
        while (instanceMetadata.containsKey(key = String.format("dwapi.%d", index))) {
            String api = instanceMetadata.get(key);
            String[] apiSplits = api.split("\\|");
            if (apiSplits.length != 2) {
                ++index;
                continue;
            }
            int tag = Integer.parseInt(apiSplits[1]);
            if (0 == (tag & 4) || this.isVersionAble(new int[]{tag}) ^ vesionAble) {
                ++index;
                continue;
            }
            if (targetEaiId.equals(apiSplits[0])) {
                return true;
            }
            ++index;
        }
        return false;
    }

    public String getEaiIdInRequest(HttpUriRequest request) {
        Header firstHeader = request.getLastHeader("digi-service");
        Map map = (Map)this.gson.fromJson(firstHeader.getValue(), Map.class);
        return (String)map.get("name");
    }
}

