/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.loadbalance.scan.candidate.v2;

import com.digiwin.app.service.DWService;
import com.digiwin.app.service.eai.EAIService;
import com.digiwin.loadbalance.scan.DWVersionable;
import com.digiwin.loadbalance.scan.candidate.v2.AbstractApiCandidateV2;
import com.digiwin.loadbalance.scan.metadata.compress.DWCommonApiMetadata;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.web.bind.annotation.RequestMethod;

public class DWEAIApiCandidateV2
extends AbstractApiCandidateV2<DWCommonApiMetadata> {
    private static Set<RequestMethod> allowMethods = new HashSet(){
        {
            this.add(RequestMethod.POST);
        }
    };

    @Override
    public List<DWCommonApiMetadata> resolverPathRegex(MetadataReader classMetadataReader, String rootPath) {
        ArrayList<DWCommonApiMetadata> apiMetadataList = new ArrayList<DWCommonApiMetadata>();
        if (classMetadataReader.getClassMetadata().isInterface() && Arrays.stream(classMetadataReader.getClassMetadata().getInterfaceNames()).filter(interfaceName -> DWService.class.getName().equals(interfaceName)).findAny().isPresent()) {
            boolean classVersionAble = classMetadataReader.getAnnotationMetadata().hasAnnotation(DWVersionable.class.getName());
            apiMetadataList.addAll(this.getEaiServiceId(classMetadataReader, EAIService.class, "id", classVersionAble));
        }
        return apiMetadataList;
    }

    private List<DWCommonApiMetadata> getEaiServiceId(MetadataReader classMetadataReader, Class annotation, String attributeName, boolean versionAble) {
        ArrayList<DWCommonApiMetadata> apiMetadataList = new ArrayList<DWCommonApiMetadata>();
        classMetadataReader.getAnnotationMetadata().getAnnotatedMethods(annotation.getName()).stream().forEach(methodMetadata -> {
            String id = methodMetadata.getAnnotationAttributes(annotation.getName()).get(attributeName).toString();
            int[] tags = this.getTags(allowMethods, this.appVersionAble() && (this.allVersionAble() || versionAble || methodMetadata.isAnnotated(DWVersionable.class.getName())));
            apiMetadataList.add(new DWCommonApiMetadata(id, tags));
        });
        return apiMetadataList;
    }

    @Override
    public int[] processBaseTages(int[] baseTags) {
        if (ArrayUtils.isEmpty((int[])baseTags)) {
            throw new IllegalArgumentException("tags must not be empty");
        }
        int baseTag = baseTags[0];
        baseTags[0] = baseTag += 4;
        return baseTags;
    }
}

