/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.loadbalance.autoconfigure;

import com.alibaba.cloud.nacos.ConditionalOnNacosDiscoveryEnabled;
import com.alibaba.cloud.nacos.NacosDiscoveryProperties;
import com.alibaba.cloud.nacos.NacosServiceManager;
import com.alibaba.cloud.nacos.discovery.NacosServiceDiscovery;
import java.lang.reflect.Field;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.client.ConditionalOnDiscoveryEnabled;
import org.springframework.cloud.commons.util.InetUtils;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.core.env.Environment;

@Configuration
@ConditionalOnDiscoveryEnabled
@ConditionalOnNacosDiscoveryEnabled
@DependsOn(value={"loadbalanceClassLoaderProvider", "loadbalanceConfigProvider", "loadbalanceGroupTargetResourceProvider", "loadbalanceModuleTargetResourceProvider", "loadbalanceSourceAppAwareProvider", "dw-spring-context-utils", "dw-json-config"})
public class NacosDiscoveryAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public NacosDiscoveryProperties nacosProperties(InetUtils inetUtils, Environment environment, NacosServiceManager nacosServiceManager, ApplicationEventPublisher applicationEventPublisher) {
        NacosDiscoveryProperties nacosProperties = new NacosDiscoveryProperties();
        try {
            Field inetUtilsField = NacosDiscoveryProperties.class.getDeclaredField("inetUtils");
            inetUtilsField.setAccessible(true);
            inetUtilsField.set(nacosProperties, inetUtils);
            Field environmentField = NacosDiscoveryProperties.class.getDeclaredField("environment");
            environmentField.setAccessible(true);
            environmentField.set(nacosProperties, environment);
            Field nacosServiceManagerField = NacosDiscoveryProperties.class.getDeclaredField("nacosServiceManager");
            nacosServiceManagerField.setAccessible(true);
            nacosServiceManagerField.set(nacosProperties, nacosServiceManager);
            Field applicationEventPublishersField = NacosDiscoveryProperties.class.getDeclaredField("applicationEventPublisher");
            applicationEventPublishersField.setAccessible(true);
            applicationEventPublishersField.set(nacosProperties, applicationEventPublisher);
            nacosProperties.init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return nacosProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    public NacosServiceDiscovery nacosServiceDiscovery(NacosDiscoveryProperties discoveryProperties, NacosServiceManager nacosServiceManager) {
        return new NacosServiceDiscovery(discoveryProperties, nacosServiceManager);
    }
}

