/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.loadbalance.autoconfigure.common;

import com.alibaba.cloud.nacos.NacosDiscoveryProperties;
import com.alibaba.nacos.client.naming.net.NamingProxy;
import com.digiwin.loadbalance.autoconfigure.DWLoadBalancerAutoConfiguration;
import com.digiwin.loadbalance.client.autoconfigure.DWClientLoadBalancerAutoConfiguration;
import com.digiwin.loadbalance.client.httpclient.DWAttemptHttpLoadbalanceRoute;
import com.digiwin.loadbalance.client.httpclient.DWDefaultHttpLoadbalanceRoute;
import com.digiwin.loadbalance.client.httpclient.DWDefaultMainExecWrapperFactory;
import com.digiwin.loadbalance.client.httpclient.DWMainExecWrapperFactory;
import com.digiwin.loadbalance.client.httpclient.reroute.DWAttemptReRoutePlanner;
import com.digiwin.loadbalance.client.httpclient.reroute.DWDefaultReRoutePlanner;
import com.digiwin.loadbalance.config.request.LoadbalanceRequestConfig;
import com.digiwin.loadbalance.discovery.DWDiscoveryProperties;
import com.digiwin.loadbalance.esp.DWEAIPropertiesBean;
import com.digiwin.loadbalance.esp.ESPExecutorPoolProperties;
import com.digiwin.loadbalance.esp.ESPLoadBalanceUtil;
import com.digiwin.loadbalance.esp.ESPServerNameCacheUtil;
import com.digiwin.loadbalance.matcher.DWMatcher;
import com.digiwin.loadbalance.matcher.UrlPathMatcher;
import com.digiwin.loadbalance.matcher.delegate.DWMatcherDelegate;
import com.digiwin.loadbalance.matcher.delegate.UrlPathMatcherDelegate;
import com.digiwin.loadbalance.matcher.v2.DWMatcherV2;
import com.digiwin.loadbalance.matcher.v2.UrlPathMatcherV2;
import com.digiwin.loadbalance.namespace.DWLoadBalancerClientFactory;
import com.digiwin.loadbalance.properties.auth.AuthenProperties;
import com.digiwin.loadbalance.properties.cache.DWCacheProperties;
import com.digiwin.loadbalance.properties.multiple.MultipleAPPProperties;
import com.digiwin.loadbalance.service.TenantIdService;
import com.digiwin.loadbalance.watch.NacosServerListWatcher;
import com.digiwin.loadbalance.watch.ServiceMetadataReactor;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.core.env.Environment;

@Configuration
@AutoConfigureAfter(value={DWClientLoadBalancerAutoConfiguration.class, DWLoadBalancerAutoConfiguration.class})
@ConditionalOnProperty(name={"digiwin.load.balance.autoCongiguration.flage"}, matchIfMissing=false)
@DependsOn(value={"loadbalanceClassLoaderProvider", "loadbalanceConfigProvider", "loadbalanceGroupTargetResourceProvider", "loadbalanceModuleTargetResourceProvider", "loadbalanceSourceAppAwareProvider", "dw-spring-context-utils", "dw-json-config"})
public class DWLoadBalanceCommonAutoconfiguration {
    @Bean
    MultipleAPPProperties multipleAPPProperties() {
        return new MultipleAPPProperties();
    }

    @Bean
    AuthenProperties autheProperties() {
        return new AuthenProperties();
    }

    @Bean
    DWCacheProperties dwCacheProperties() {
        return new DWCacheProperties();
    }

    @Bean
    ESPExecutorPoolProperties espExecutorPoolProperties() {
        return new ESPExecutorPoolProperties();
    }

    @Bean
    public ESPLoadBalanceUtil init(DiscoveryClient discoveryClient, @Qualifier(value="dwDefaultHttpLoadbalanceRoute") HttpRoutePlanner dwRoutePlanner, ObjectProvider<NacosServerListWatcher> nacosServerListWatcher, Environment environment, ObjectProvider<NacosDiscoveryProperties> nacosDiscoveryProperties, ESPExecutorPoolProperties espExecutorPoolProperties, ObjectProvider<DWEAIPropertiesBean> eaiPropertiesProvider, ObjectProvider<DWDiscoveryProperties> dwDiscoveryProperties, ObjectProvider<ServiceMetadataReactor> serviceMetadataReactor, TenantIdService tenantIdService, @Qualifier(value="dwDefaultReRoutePlanner") HttpRoutePlanner dwDefaultReRoutePlanner, ObjectProvider<NamingProxy> namingProxy, @Qualifier(value="dwDefaultMainExecWrapperFactory") DWMainExecWrapperFactory dwMainExecWrapperFactory, DWCacheProperties dwCacheProperties) {
        ESPServerNameCacheUtil.initAnonymousCache((int)dwCacheProperties.getMdc_prod_name_cache_inital(), (long)dwCacheProperties.getMdc_prod_name_cache_max(), (long)dwCacheProperties.getMdc_prod_name_cache_millis());
        ESPServerNameCacheUtil.initRegiestedCache((int)dwCacheProperties.getEai_registed_cache_inital(), (long)dwCacheProperties.getEai_registed_cache_max(), (long)dwCacheProperties.getEai_registed_cache_millis());
        ESPServerNameCacheUtil.initUnRegiestedCache((int)dwCacheProperties.getEai_unregisted_cache_inital(), (long)dwCacheProperties.getEai_unregisted_cache_max(), (long)dwCacheProperties.getEai_unregisted_cache_millis());
        ESPLoadBalanceUtil espLoadBalanceUtil = new ESPLoadBalanceUtil();
        ESPLoadBalanceUtil.setEnvironment((Environment)environment);
        ESPLoadBalanceUtil.setCacheAnonymous((boolean)dwCacheProperties.isAnonymousCache());
        String dwloadBalanceEnable = environment.getProperty("dwloadBalanceEnable");
        String esploadBalanceEnable = environment.getProperty("esp.loadbalance.enable");
        String cacheUnregisteredService = environment.getProperty("esp.cache.unregistered.service");
        if ("false".equalsIgnoreCase(cacheUnregisteredService)) {
            ESPLoadBalanceUtil.setCacheUnregisteredService((boolean)false);
        }
        if ("true".equalsIgnoreCase(dwloadBalanceEnable) && !"false".equalsIgnoreCase(esploadBalanceEnable)) {
            ESPLoadBalanceUtil.setLoadBalanceEnable((boolean)true);
        } else {
            ESPLoadBalanceUtil.setLoadBalanceEnable((boolean)false);
        }
        ESPLoadBalanceUtil.setDiscoveryClient((DiscoveryClient)discoveryClient);
        ESPLoadBalanceUtil.setDwRoutePlanner((HttpRoutePlanner)dwRoutePlanner);
        ESPLoadBalanceUtil.setNacosServerListWatcher((NacosServerListWatcher)((NacosServerListWatcher)nacosServerListWatcher.getIfAvailable()));
        ESPLoadBalanceUtil.setDiscoveryProperties((NacosDiscoveryProperties)((NacosDiscoveryProperties)nacosDiscoveryProperties.getIfAvailable()));
        ESPLoadBalanceUtil.setEspExecutorPoolProperties((ESPExecutorPoolProperties)espExecutorPoolProperties);
        ESPLoadBalanceUtil.setNamingHttpClientProxy((NamingProxy)((NamingProxy)namingProxy.getIfAvailable()));
        ESPLoadBalanceUtil.setDwDiscoveryProperties((DWDiscoveryProperties)((DWDiscoveryProperties)dwDiscoveryProperties.getIfAvailable()));
        ESPLoadBalanceUtil.setServiceMetadataReactor((ServiceMetadataReactor)((ServiceMetadataReactor)serviceMetadataReactor.getIfAvailable()));
        ESPLoadBalanceUtil.setTenantIdService((TenantIdService)tenantIdService);
        DWEAIPropertiesBean eaiProperties = (DWEAIPropertiesBean)eaiPropertiesProvider.getIfAvailable();
        if (null != eaiProperties) {
            if (StringUtils.isNumeric((CharSequence)eaiProperties.getHostRetryInterval())) {
                ESPLoadBalanceUtil.setEaiHostRetryInterval((int)Integer.valueOf(eaiProperties.getHostRetryInterval()));
            }
            if (StringUtils.isNumeric((CharSequence)eaiProperties.getHostRetryTimes())) {
                ESPLoadBalanceUtil.setEaiHostRetryTimes((int)Integer.valueOf(eaiProperties.getHostRetryTimes()));
            }
            ESPLoadBalanceUtil.setEaiRestfulPath((String)eaiProperties.getRestfulServicePath());
            ESPLoadBalanceUtil.setEaiCallbackPath((String)eaiProperties.getRestfulServiceCallbackPath());
        }
        ESPLoadBalanceUtil.setDwMainExecWrapperFactory((DWMainExecWrapperFactory)dwMainExecWrapperFactory);
        ESPLoadBalanceUtil.setDwRerouteRoutePlanner((HttpRoutePlanner)dwDefaultReRoutePlanner);
        ESPLoadBalanceUtil.init();
        return espLoadBalanceUtil;
    }

    @ConditionalOnClass(value={HttpClient.class})
    @Bean(value={"dwDefaultHttpLoadbalanceRoute"})
    HttpRoutePlanner dwHttpLoadbalanceRoute(DWLoadBalancerClientFactory loadBalancerClientFactory, AuthenProperties authenProperties, TenantIdService tenantIdService, DiscoveryClient discoveryClient, MultipleAPPProperties multipleAPPProperties, LoadbalanceRequestConfig loadbalanceRequestConfig) {
        return new DWDefaultHttpLoadbalanceRoute(authenProperties, loadBalancerClientFactory, tenantIdService, discoveryClient, multipleAPPProperties, loadbalanceRequestConfig);
    }

    @ConditionalOnClass(value={HttpClient.class})
    @Bean(value={"dwAttemptHttpLoadbalanceRoute"})
    @ConditionalOnProperty(name={"dwhttpClient.loadbalance.mode"}, havingValue="auto")
    HttpRoutePlanner dwAttemptHttpLoadbalanceRoute(DWLoadBalancerClientFactory loadBalancerClientFactory, AuthenProperties authenProperties, TenantIdService tenantIdService, DiscoveryClient discoveryClient, MultipleAPPProperties multipleAPPProperties, LoadbalanceRequestConfig loadbalanceRequestConfig) {
        return new DWAttemptHttpLoadbalanceRoute(authenProperties, loadBalancerClientFactory, tenantIdService, discoveryClient, multipleAPPProperties, loadbalanceRequestConfig);
    }

    @ConditionalOnClass(value={HttpClient.class})
    @Bean(value={"dwDefaultReRoutePlanner"})
    HttpRoutePlanner dwDefaultReRoutePlanner(DWLoadBalancerClientFactory loadBalancerClientFactory, AuthenProperties authenProperties, TenantIdService tenantIdService, DiscoveryClient discoveryClient, MultipleAPPProperties multipleAPPProperties, LoadbalanceRequestConfig loadbalanceRequestConfig) {
        return new DWDefaultReRoutePlanner(authenProperties, loadBalancerClientFactory, tenantIdService, discoveryClient, multipleAPPProperties, loadbalanceRequestConfig);
    }

    @ConditionalOnClass(value={HttpClient.class})
    @Bean(value={"dwAttemptReRoutePlanner"})
    @ConditionalOnProperty(name={"dwhttpClient.loadbalance.mode"}, havingValue="auto")
    HttpRoutePlanner dwWAttemptReRoutePlanner(DWLoadBalancerClientFactory loadBalancerClientFactory, AuthenProperties authenProperties, TenantIdService tenantIdService, DiscoveryClient discoveryClient, MultipleAPPProperties multipleAPPProperties, LoadbalanceRequestConfig loadbalanceRequestConfig) {
        return new DWAttemptReRoutePlanner(authenProperties, loadBalancerClientFactory, tenantIdService, discoveryClient, multipleAPPProperties, loadbalanceRequestConfig);
    }

    @Bean
    DWMatcher urlPathMatcher() {
        return new UrlPathMatcher();
    }

    @Bean
    DWMatcherV2 urlPathMatcherV2() {
        return new UrlPathMatcherV2();
    }

    @Bean
    @DependsOn(value={"urlPathMatcherV2", "urlPathMatcher"})
    DWMatcherDelegate urlPathMatcherDelegate() {
        return new UrlPathMatcherDelegate();
    }

    @Bean(value={"dwDefaultMainExecWrapperFactory"})
    @ConditionalOnClass(value={HttpClient.class})
    DWMainExecWrapperFactory dwDefaultMainExecWrapperFactory(DiscoveryClient discoveryClient, DWLoadBalancerClientFactory loadBalancerClientFactory, Environment environment) {
        return new DWDefaultMainExecWrapperFactory(discoveryClient, loadBalancerClientFactory, !"auto".equalsIgnoreCase(environment.getProperty("dwhttpClient.loadbalance.mode")));
    }

    @Bean
    LoadbalanceRequestConfig loadbalanceRequestConfig(Environment environment) {
        String requestPropertyPrefix = environment.getProperty("dap.http.client.config.prefix", "dw") + "HttpRequestConfig";
        int connectionRequestTimeout = (Integer)environment.getProperty(requestPropertyPrefix + "ConnectionRequestTimeout", Integer.class, (Object)-1);
        int connectTimeout = (Integer)environment.getProperty(requestPropertyPrefix + "ConnectTimeout", Integer.class, (Object)-1);
        int socketTimeout = (Integer)environment.getProperty(requestPropertyPrefix + "SocketTimeout", Integer.class, (Object)-1);
        long requestSize = (Long)environment.getProperty(requestPropertyPrefix + "RequestSize", Long.class, (Object)0xA00000L);
        boolean enableRequestSizeLimit = (Boolean)environment.getProperty(requestPropertyPrefix + "RequestSizeLimit", Boolean.class, (Object)false);
        boolean enableRequestTimeLimit = (Boolean)environment.getProperty(requestPropertyPrefix + "RequestTimeLimit", Boolean.class, (Object)false);
        return new LoadbalanceRequestConfig(connectionRequestTimeout, connectTimeout, socketTimeout, requestSize, enableRequestSizeLimit, enableRequestTimeLimit);
    }
}

