/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.loadbalance.client.httpclient;

import com.digiwin.http.context.DWLoadBalanceUtils;
import com.digiwin.loadbalance.client.httpclient.BaseHttpRoutePlanner;
import com.digiwin.loadbalance.config.request.LoadbalanceRequestConfig;
import com.digiwin.loadbalance.exception.DWInstanceServiceNotFoundException;
import com.digiwin.loadbalance.namespace.DWLoadBalancerClientFactory;
import com.digiwin.loadbalance.properties.auth.AuthenProperties;
import com.digiwin.loadbalance.properties.multiple.MultipleAPPProperties;
import com.digiwin.loadbalance.service.TenantIdService;
import com.digiwin.loadbalance.util.DWLoadBalanceRequestUtils;
import com.digiwin.loadbalance.util.HttpRouteUtils;
import java.util.Collection;
import java.util.Objects;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.protocol.HttpContext;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.loadbalancer.ServiceInstanceChooser;
import org.springframework.util.CollectionUtils;

public class DWDefaultHttpLoadbalanceRoute
extends BaseHttpRoutePlanner {
    private static Log log = LogFactory.getLog(DWDefaultHttpLoadbalanceRoute.class);

    public DWDefaultHttpLoadbalanceRoute(AuthenProperties authenProperties, DWLoadBalancerClientFactory loadBalancerClientFactory, TenantIdService tenantIdService, DiscoveryClient discoveryClient, MultipleAPPProperties multipleAPPProperties, LoadbalanceRequestConfig loadbalanceRequestConfig) {
        super(authenProperties, loadBalancerClientFactory, tenantIdService, discoveryClient, multipleAPPProperties, loadbalanceRequestConfig);
    }

    public HttpRoute determineRoute(HttpHost httpHost, HttpRequest request, HttpContext context) throws HttpException {
        log.debug((Object)("httpHost:" + String.valueOf(httpHost)));
        if (Objects.nonNull(DWLoadBalanceUtils.getLoadBalanceFlag()) && !DWLoadBalanceUtils.getLoadBalanceFlag().booleanValue()) {
            log.info((Object)"DWDefaultHttpLoadbalanceRoute LoadBalanceFlag false  ");
            DWLoadBalanceUtils.resetFlag();
            DWLoadBalanceUtils.setDecentralized((HttpContext)context, (boolean)false);
            return new HttpRoute(httpHost);
        }
        DWLoadBalanceUtils.resetFlag();
        DWLoadBalanceUtils.setDecentralized((HttpContext)context, (boolean)true);
        HttpHost processedHost = this.beforeRoute(httpHost, request, context);
        context.setAttribute("dwloadbalance.service.name", (Object)processedHost.getHostName());
        if (CollectionUtils.isEmpty((Collection)this.getDiscoveryClient().getInstances(processedHost.getHostName()))) {
            log.error((Object)("no service instance named  " + processedHost.getHostName()));
            throw new DWInstanceServiceNotFoundException(HttpRouteUtils.INSTANCE_NOT_FOUND_ERROR_MESSAGE + processedHost.getHostName());
        }
        HttpRequestWrapper wrapRequest = HttpRequestWrapper.wrap((HttpRequest)request);
        DWLoadBalanceRequestUtils.setRequest((HttpUriRequest)wrapRequest);
        String tenantId = null;
        try {
            tenantId = this.getTenantId(wrapRequest);
            DWLoadBalanceRequestUtils.setTenantId(tenantId);
        }
        catch (Exception e) {
            log.error((Object)("get TenantId fail tenantId: " + tenantId), (Throwable)e);
            throw new HttpException("get TenantId fail", (Throwable)e);
        }
        ServiceInstanceChooser loadBalancer = this.getLoadBalancerClientFactory().getInstance(processedHost.getHostName());
        ServiceInstance server = loadBalancer.choose(processedHost.getHostName());
        if (null == server) {
            log.error((Object)("find service fail host:" + String.valueOf(processedHost) + ", url:" + String.valueOf(wrapRequest.getURI()) + ",tenantId:" + tenantId));
            throw new HttpException("Service not found");
        }
        HttpHost tragetHost = new HttpHost(server.getHost(), server.getPort());
        log.info((Object)("target host:" + String.valueOf(tragetHost) + " for: " + String.valueOf(processedHost)));
        return new HttpRoute(tragetHost);
    }

    @Override
    public void beforeLoadbalance(HttpHost httpHost, HttpRequest request, HttpContext context) {
        super.beforeLoadbalance(httpHost, request, context);
        if (this.getLoadbalanceRequestConfig().isEnableRequestSizeLimit() && context.getAttribute("http.request-config") == null) {
            context.setAttribute("http.request-config", context.getAttribute(HttpRouteUtils.LOADBALANCE_REQUEST_CONFIG));
        }
    }
}

