/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.loadbalance.region;

import com.ctrip.framework.apollo.Config;
import com.ctrip.framework.apollo.ConfigChangeListener;
import com.ctrip.framework.apollo.ConfigService;
import com.ctrip.framework.apollo.model.ConfigChangeEvent;
import com.digiwin.loadbalance.region.RegionSwitch;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.context.ApplicationContext;

public class DefaultRegionSwitch
implements RegionSwitch,
ConfigChangeListener {
    private static Log log = LogFactory.getLog(DefaultRegionSwitch.class);
    private static String NULL_TENANTID = "NULL@@TENANTID";
    ApplicationContext applicationContext;
    private String serviceName;
    private Map<String, Map<String, String>> preMap = new ConcurrentHashMap<String, Map<String, String>>();

    public DefaultRegionSwitch(String serviceName, ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        this.serviceName = serviceName;
        String ar = serviceName + "_ar";
        Config config = ConfigService.getConfig((String)ar);
        config.addChangeListener((ConfigChangeListener)this);
        this.loadRouteMap();
    }

    public Optional<Predicate<? super ServiceInstance>> getRegionPredicate(String tenantId) {
        return this.getPredicate(StringUtils.isBlank((CharSequence)tenantId) ? NULL_TENANTID : tenantId);
    }

    private Optional<Predicate<? super ServiceInstance>> getPredicate(String tenantId) {
        return Optional.of(seviceInstance -> {
            String instanceIamge = (String)seviceInstance.getMetadata().get("APPIMAGENAME");
            String instanceRegion = (String)seviceInstance.getMetadata().get("STATEMODE");
            if (StringUtils.isBlank((CharSequence)instanceIamge)) {
                return true;
            }
            String arNameSpace = this.serviceName + "_ar";
            Config arConfig = ConfigService.getConfig((String)arNameSpace);
            String target_region = null;
            target_region = this.getTargetRegion(instanceIamge, tenantId);
            return StringUtils.isBlank((CharSequence)target_region) ? arConfig.getProperty(instanceIamge, "").equals(instanceRegion) : instanceRegion.equals(target_region);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onChange(ConfigChangeEvent changeEvent) {
        Map<String, Map<String, String>> map = this.preMap;
        synchronized (map) {
            this.loadRouteMap();
        }
    }

    public void loadRouteMap() {
        ConcurrentHashMap<String, ConcurrentHashMap<String, String>> newMap = new ConcurrentHashMap<String, ConcurrentHashMap<String, String>>();
        Config arConfig = ConfigService.getConfig((String)(this.serviceName + "_ar"));
        Set imageNames = arConfig.getPropertyNames();
        for (String string : imageNames) {
            String imagedTrName = this.serviceName + "_" + string + "_tr";
            Config imagedTrConfig = ConfigService.getConfig((String)imagedTrName);
            imagedTrConfig.addChangeListener((ConfigChangeListener)this);
            String activeRegion = arConfig.getProperty(string, "");
            if (StringUtils.isBlank((CharSequence)activeRegion)) continue;
            List preRegions = imagedTrConfig.getPropertyNames().stream().filter(regionName -> !activeRegion.equals(regionName)).collect(Collectors.toList());
            for (String preRegion : preRegions) {
                String[] preTentantIds;
                for (String preTentantId : preTentantIds = imagedTrConfig.getArrayProperty(preRegion, ",", new String[0])) {
                    ConcurrentHashMap<String, String> imageMapPreRegion = (ConcurrentHashMap<String, String>)newMap.get(preTentantId);
                    if (null == imageMapPreRegion) {
                        imageMapPreRegion = new ConcurrentHashMap<String, String>();
                        newMap.put(preTentantId, imageMapPreRegion);
                    }
                    imageMapPreRegion.put(string, preRegion);
                }
            }
        }
        for (Map.Entry entry : this.preMap.entrySet()) {
            if (newMap.containsKey(entry.getKey())) continue;
            this.preMap.remove(entry.getKey());
        }
        for (Map.Entry entry : newMap.entrySet()) {
            this.preMap.put((String)entry.getKey(), (Map)entry.getValue());
        }
    }

    String getTargetRegion(String imageName, String tenantId) {
        String targetRegion = (String)((Map)this.preMap.getOrDefault(tenantId, new HashMap())).get(imageName);
        return targetRegion;
    }
}

