/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.loadbalance.task;

import com.digiwin.loadbalance.task.DigiwinAbstractExecuteTask;
import com.digiwin.loadbalance.task.DigiwinTaskProcessor;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DigiwinTaskExecuteWorker
implements DigiwinTaskProcessor<DigiwinAbstractExecuteTask>,
Closeable {
    private static Log log = LogFactory.getLog(DigiwinTaskExecuteWorker.class);
    private static final int QUEUE_CAPACITY = 32768;
    private final AtomicBoolean closed;
    private final BlockingQueue<Runnable> queue = new ArrayBlockingQueue<Runnable>(32768);
    private final InnerWorker realWorker;

    public DigiwinTaskExecuteWorker(String name) {
        this.closed = new AtomicBoolean(false);
        this.realWorker = new InnerWorker(name);
        this.realWorker.start();
    }

    @Override
    public boolean process(DigiwinAbstractExecuteTask task) {
        if (task instanceof DigiwinAbstractExecuteTask) {
            this.putTask(task);
        }
        return true;
    }

    private void putTask(Runnable task) {
        try {
            this.queue.put(task);
        }
        catch (InterruptedException ire) {
            log.error((Object)ire.toString(), (Throwable)ire);
        }
    }

    @Override
    public void close() throws IOException {
    }

    private class InnerWorker
    extends Thread {
        InnerWorker(String name) {
            this.setDaemon(false);
            this.setName(name);
        }

        @Override
        public void run() {
            while (!DigiwinTaskExecuteWorker.this.closed.get()) {
                try {
                    Runnable task = DigiwinTaskExecuteWorker.this.queue.take();
                    long begin = System.currentTimeMillis();
                    task.run();
                    long duration = System.currentTimeMillis() - begin;
                    if (duration <= 2000L) continue;
                    log.warn((Object)("task " + String.valueOf(task) + " takes " + duration + "ms"));
                }
                catch (Throwable e) {
                    log.error((Object)("[DigiwinTaskExecuteWorker-FAILED] " + String.valueOf(e)), e);
                }
            }
        }
    }
}

