/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.loadbalance.client.config;

import com.ctrip.framework.apollo.Config;
import com.ctrip.framework.apollo.ConfigService;
import com.ctrip.framework.apollo.core.utils.StringUtils;
import com.digiwin.loadbalance.client.config.TenantServiceConfig;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class DWDefaultTenantServiceConfig
implements TenantServiceConfig {
    private final String Tenant_Version_Sufix = "tv";
    private final String serviceNameSpace;
    public Map<String, String> tenantVersionMap = new ConcurrentHashMap<String, String>();

    public DWDefaultTenantServiceConfig(String serviceName) {
        this.serviceNameSpace = serviceName + "_tv";
        Config config = ConfigService.getConfig((String)this.serviceNameSpace);
        this.fillTenantVersion(config);
        config.addChangeListener(changeEvent -> {
            this.tenantVersionMap.clear();
            this.fillTenantVersion(config);
        });
    }

    public void fillTenantVersion(Config config) {
        config.getPropertyNames().stream().forEach(version -> {
            String property = config.getProperty(version, null);
            if (Objects.nonNull(property)) {
                Arrays.stream(property.split(",")).forEach(tentId -> this.tenantVersionMap.put((String)tentId, (String)version));
            }
        });
    }

    public String getServiceVersion(String tenantId) {
        if (StringUtils.isEmpty((String)tenantId) || !this.tenantVersionMap.containsKey(tenantId)) {
            return "default";
        }
        return this.tenantVersionMap.get(tenantId);
    }
}

