/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.log.operation.context;

import com.digiwin.app.log.operation.utils.DWLogOperationPropertyUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DWLogOperationContextUtil {
    private static Log LOGGER = LogFactory.getLog(DWLogOperationContextUtil.class);

    public void writeSqlInfoToServiceContext(String sql, List<Object> parameterMappingList, Map<String, Object> operateLogData, Map<String, Object> sqlLogOptions) {
        boolean configOfServiceLogForOperate = false;
        if (MapUtils.isNotEmpty(operateLogData) && operateLogData.containsKey("isLogRecord") && ((Boolean)operateLogData.get("isLogRecord")).booleanValue()) {
            configOfServiceLogForOperate = true;
        }
        if (configOfServiceLogForOperate) {
            boolean combinedConfigValueOfSqlLogForOperate = true;
            boolean collectSqlLogForOperate = false;
            boolean daoOptionValueOfOperateLogEnabled = true;
            if (MapUtils.isNotEmpty(operateLogData) && operateLogData.containsKey("isLogSqlRecord")) {
                combinedConfigValueOfSqlLogForOperate = (Boolean)operateLogData.get("isLogSqlRecord");
            }
            if (combinedConfigValueOfSqlLogForOperate) {
                collectSqlLogForOperate = sqlLogOptions != null ? (daoOptionValueOfOperateLogEnabled = BooleanUtils.toBooleanDefaultIfNull((Boolean)DWLogOperationPropertyUtil.getEnabled(sqlLogOptions), (boolean)false)) : true;
            }
            if (collectSqlLogForOperate) {
                HashMap<String, Object> currentSqlMap = new HashMap<String, Object>();
                currentSqlMap.put("statement", sql);
                currentSqlMap.put("parameters", parameterMappingList);
                HashMap<Integer, HashMap<Integer, HashMap<String, Object>>> logRecordSqlMap = (HashMap<Integer, HashMap<Integer, HashMap<String, Object>>>)operateLogData.get("sqlMap");
                if (MapUtils.isNotEmpty((Map)logRecordSqlMap)) {
                    logRecordSqlMap.put(logRecordSqlMap.size() + 1, currentSqlMap);
                } else {
                    logRecordSqlMap = new HashMap<Integer, HashMap<Integer, HashMap<String, Object>>>();
                    logRecordSqlMap.put(1, currentSqlMap);
                    operateLogData.put("sqlMap", logRecordSqlMap);
                }
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)String.format("collectSqlLogForOperate=%b (configOfServiceLogForOperate=%b, combinedConfigValueOfSqlLogForOperate=%b, daoOptionValueOfOperateLogEnabled=%s !)", collectSqlLogForOperate, configOfServiceLogForOperate, combinedConfigValueOfSqlLogForOperate, daoOptionValueOfOperateLogEnabled));
            }
        }
    }
}

