/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.dao.mybatis.utils;

import com.dap.component.mybatis.api.MybatisConfigProviderProvider;
import com.digiwin.app.dao.mybatis.DWMybatisConstants;
import com.digiwin.app.dao.mybatis.DWMybatisSqlManagementField;
import com.digiwin.app.module.spring.SpringContextUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ibatis.mapping.SqlCommandType;

public class DWMybatisSqlStatementHelper {
    private static String tenantColumnName = DWMybatisConstants.tenantColumnname;
    private static String IAM_TENANTSIDKEY = DWMybatisSqlStatementHelper.getIAMTenantSidKey();
    private static String dwMybatisSqlStatementAffix = "%%";
    private static String mybatisBaseTenantTag = "{" + tenantColumnName + "}";
    private static String mybatisBaseTenantNameTag = "{tenantName}";
    private static String mybatisBaseTenantValueTag = "{tenantValue}";
    private static String sqlTenantTagDD = dwMybatisSqlStatementAffix + mybatisBaseTenantTag + dwMybatisSqlStatementAffix;
    private static String sqlTenantNameTagDD = dwMybatisSqlStatementAffix + mybatisBaseTenantNameTag + dwMybatisSqlStatementAffix;
    private static String sqlTenantValueTagDD = dwMybatisSqlStatementAffix + mybatisBaseTenantValueTag + dwMybatisSqlStatementAffix;
    private static String sqlIgnoreTenantTagDD = dwMybatisSqlStatementAffix + "-" + mybatisBaseTenantTag + dwMybatisSqlStatementAffix;
    private static String sqlIgnoreTenantNameTagDD = dwMybatisSqlStatementAffix + "-" + mybatisBaseTenantNameTag + dwMybatisSqlStatementAffix;
    private static String sqlIgnoreTenantValueTagDD = dwMybatisSqlStatementAffix + "-" + mybatisBaseTenantValueTag + dwMybatisSqlStatementAffix;
    private static final String _matchQuoteEmpty = Matcher.quoteReplacement(" ");
    private static final HashSet<SqlCommandType> MgmtSqlCommandTypeSet = new HashSet<SqlCommandType>(Arrays.asList(SqlCommandType.INSERT, SqlCommandType.UPDATE));
    String regEx = "(?s).%%\\{.*?" + tenantColumnName + "\\}" + dwMybatisSqlStatementAffix;
    String regExCheckTenantTag = "(?s).*?" + tenantColumnName + "\\}" + dwMybatisSqlStatementAffix;
    static String basePrefixRegexp = "(?s)%{2}\\{";
    static String basePostfixRegexp = "\\}%{2}";
    static String regExTagWithAlias = basePrefixRegexp + "[/\\w-]+\\." + tenantColumnName + basePostfixRegexp;
    String postfixRegex = "." + tenantColumnName + basePostfixRegexp;
    private static Pattern patternTagWithAlias = Pattern.compile(regExTagWithAlias);

    private static String getIAMTenantSidKey() {
        MybatisConfigProviderProvider configProvider = (MybatisConfigProviderProvider)SpringContextUtils.getBean((String)"mybatisConfigProviderProvider");
        String IAM_TENANTSIDKEY = configProvider.getIAMTenantSidKey();
        return IAM_TENANTSIDKEY;
    }

    public static boolean checkTagExist(String sqlCommand) {
        boolean returnValue = false;
        if (DWMybatisSqlStatementHelper.checkTagTenantExist(sqlCommand) || DWMybatisSqlStatementHelper.checkTagMgmtExist(sqlCommand)) {
            return true;
        }
        return returnValue;
    }

    public static boolean checkTagTenantExist(String sqlCommand) {
        boolean returnValue = false;
        if (sqlCommand.contains(sqlTenantTagDD) || sqlCommand.contains(sqlTenantNameTagDD) || sqlCommand.contains(sqlTenantValueTagDD) || patternTagWithAlias.matcher(sqlCommand).find()) {
            return true;
        }
        return returnValue;
    }

    public static boolean checkTagMgmtExist(String sqlCommand) {
        boolean returnValue = false;
        if (sqlCommand.contains(DWMybatisSqlManagementField.TAG_MGMT_FIELD_INSERT_COLUMNS) || sqlCommand.contains(DWMybatisSqlManagementField.TAG_MGMT_FIELD_INSERT_PARAMS) || sqlCommand.contains(DWMybatisSqlManagementField.TAG_MGMT_FIELD_UPDATE_COLUMNS)) {
            return true;
        }
        return returnValue;
    }
}

