/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.autoconfigure;

import com.dap.component.redis.api.RedisPrefixProvider;
import com.digiwin.app.redis.service.DWRedisService;
import com.digiwin.app.redis.service.DefaultRedisPrefixProvider;
import com.digiwin.app.redis.service.DefaultRedisService;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.data.redis.core.RedisTemplate;

@DependsOn(value={"dw-spring-context-utils"})
@Configuration
public class DWRedisAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public DWRedisService redisService(RedisTemplate<String, Object> redisTemplate, RedisPrefixProvider redisPrefixProvider) {
        DefaultRedisService redisService = new DefaultRedisService(redisPrefixProvider);
        redisService.setOperator(redisTemplate);
        return redisService;
    }

    @Bean
    @ConditionalOnMissingBean
    public RedisPrefixProvider redisPrefixProvider() {
        return new DefaultRedisPrefixProvider();
    }
}

