/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.redisson.service;

import com.dap.component.redisson.api.DapRedissonLockGenerator;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.module.spring.SpringContextUtils;
import com.digiwin.app.redisson.service.DWRedissonLock;
import com.digiwin.app.redisson.service.IDWRedissonPrefix;
import com.digiwin.app.redisson.service.impl.DWFairLockImpl;
import com.digiwin.app.redisson.service.impl.DWLockImpl;
import com.digiwin.app.redisson.service.impl.DWReadWriteLock;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.redisson.api.RedissonClient;
import org.springframework.data.redis.core.RedisTemplate;

public class DWRedissonLockGenerator
implements DapRedissonLockGenerator {
    protected RedissonClient redissonClient = null;
    protected RedisTemplate redisTemplate = null;

    public DWRedissonLockGenerator(RedissonClient redissonClient, RedisTemplate redisTemplate) {
        this.redissonClient = redissonClient;
        this.redisTemplate = redisTemplate;
    }

    @Override
    public DWRedissonLock generateLock(String lockName) throws DWBusinessException {
        return this.generateLock(lockName, null);
    }

    @Override
    public DWRedissonLock generateLock(String lockName, String prefixBeanName) throws DWBusinessException {
        return this.generateLock(lockName, -1L, -1L, TimeUnit.SECONDS, prefixBeanName);
    }

    @Override
    public DWRedissonLock generateLock(String lockName, long leaseTime, long waitTime, TimeUnit unit, String prefixBeanName) throws DWBusinessException {
        return new DWLockImpl(this.generateLockName(lockName, prefixBeanName, DWLockImpl::getLOCKTYPE), leaseTime, waitTime, unit, this.redissonClient, this.redisTemplate);
    }

    @Override
    public DWRedissonLock generateFairLock(String lockName) throws DWBusinessException {
        return this.generateFairLock(lockName, null);
    }

    @Override
    public DWRedissonLock generateFairLock(String lockName, String prefixBeanName) throws DWBusinessException {
        return this.generateFairLock(lockName, -1L, -1L, TimeUnit.SECONDS, prefixBeanName);
    }

    @Override
    public DWRedissonLock generateFairLock(String lockName, long leaseTime, long waitTime, TimeUnit unit, String prefixBeanName) throws DWBusinessException {
        return new DWFairLockImpl(this.generateLockName(lockName, prefixBeanName, DWFairLockImpl::getLOCKTYPE), leaseTime, waitTime, unit, this.redissonClient, this.redisTemplate);
    }

    @Override
    public DWReadWriteLock generateReadWriteLock(String lockName) throws DWBusinessException {
        return this.generateReadWriteLock(lockName, null);
    }

    @Override
    public DWReadWriteLock generateReadWriteLock(String lockName, String prefixBeanName) throws DWBusinessException {
        return new DWReadWriteLock(this.generateLockName(lockName, prefixBeanName, DWReadWriteLock::getLOCKTYPE), this.redissonClient, this.redisTemplate);
    }

    private String generateLockName(String lockName, String prefixBeanName, Supplier<String> getLockType) throws DWBusinessException {
        if (StringUtils.isEmpty((CharSequence)prefixBeanName)) {
            prefixBeanName = "redisson-lock-prefix-tenant";
        }
        IDWRedissonPrefix redissonPrefix = (IDWRedissonPrefix)SpringContextUtils.getBean((String)prefixBeanName);
        return redissonPrefix.getLockName(lockName, getLockType.get());
    }
}

