/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.redisson.service;

import com.dap.component.redisson.api.RedissonRequestContextProvider;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.module.spring.SpringContextUtils;
import com.digiwin.app.redisson.exception.DWUnlockException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.redisson.api.RLock;
import org.springframework.core.env.Environment;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.script.DefaultRedisScript;
import org.springframework.data.redis.core.script.RedisScript;

public abstract class DWRedissonLock {
    protected String lockName = null;
    protected long leaseTime = -1L;
    protected TimeUnit unit = TimeUnit.SECONDS;
    protected long waitTime = -1L;
    protected RedisTemplate redisTemplate;
    protected Environment environment;
    DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    public RLock lock;

    public DWRedissonLock(String lockName, long leaseTime, long waitTime, TimeUnit unit) throws DWBusinessException {
        if (StringUtils.isEmpty((CharSequence)lockName)) {
            throw new DWBusinessException("\u9396\u540d\u7a31\u4e0d\u80fd\u7232\u7a7a");
        }
        this.environment = SpringContextUtils.getEnvironment();
        this.lockName = lockName;
        this.leaseTime = leaseTime;
        this.waitTime = waitTime;
        this.unit = unit;
    }

    public abstract void lock();

    public abstract void lock(long var1, TimeUnit var3);

    public abstract boolean tryLock() throws InterruptedException;

    public abstract boolean tryLock(long var1, long var3, TimeUnit var5) throws InterruptedException;

    public abstract void unlock() throws DWUnlockException;

    public abstract boolean isHeldByCurrentThread();

    public abstract boolean isLocked();

    public boolean forceUnlock() {
        StringBuilder builder = new StringBuilder(this.lockName);
        String redisKey = builder.append(":forceUnlock").toString();
        builder.setLength(0);
        RedissonRequestContextProvider requestContextProvider = (RedissonRequestContextProvider)SpringContextUtils.getBean((String)"redissonRequestContextProvider");
        String userName = requestContextProvider.getContextUsername();
        String userSid = requestContextProvider.getContextUsersid();
        String date = this.formatter.format(LocalDateTime.now());
        String redisValue = builder.append(userSid).append(":").append(userName).append(":").append(date).toString();
        boolean result = this.lock.forceUnlock();
        if (result) {
            DefaultRedisScript defaultRedisScript = new DefaultRedisScript();
            defaultRedisScript.setScriptText("if redis.call('exists', KEYS[1]) == 1 then if redis.call('llen', KEYS[1]) >= 10 then redis.call('rpop', KEYS[1]); end; redis.call('lpush', KEYS[1],ARGV[1]); else redis.call('lpush', KEYS[1],ARGV[1]); redis.call('pexpire', KEYS[1],ARGV[2]); end; ");
            ArrayList<String> keyList = new ArrayList<String>();
            keyList.add(redisKey);
            this.redisTemplate.execute((RedisScript)defaultRedisScript, keyList, new Object[]{redisValue, 86400000L});
        }
        return result;
    }

    public synchronized List<Map<String, String>> getForceUnlockHistory(String lockName) {
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        List historyItem = this.redisTemplate.opsForList().range((Object)lockName, 0L, 10L);
        if (historyItem != null) {
            HashMap history = new HashMap();
            historyItem.forEach(item -> {
                String[] values = item.split(":");
                history.put("userSid", values[0]);
                history.put("userName", values[1]);
                history.put("date", values[2]);
            });
            result.add(history);
        }
        return result;
    }
}

