/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.redisson.customize;

import com.digiwin.app.redisson.constant.DWRedissonConstants;
import org.redisson.config.ClusterServersConfig;
import org.redisson.config.Config;
import org.redisson.spring.starter.RedissonAutoConfigurationCustomizer;
import org.redisson.spring.starter.RedissonProperties;

public class DWRedissonAutoConfigurationCustomizer
implements RedissonAutoConfigurationCustomizer {
    private RedissonProperties redissonProperties;

    public void customize(Config config) {
        if (config.isSentinelConfig()) {
            if ("".equals(config.useSentinelServers().getPassword())) {
                config.useSentinelServers().setPassword(null);
            }
        } else if (config.isClusterConfig()) {
            if ("".equals(config.useClusterServers().getPassword())) {
                config.useClusterServers().setPassword(null);
            }
        } else if (config.useSingleServer() != null) {
            if ("".equals(config.useSingleServer().getPassword())) {
                config.useSingleServer().setPassword(null);
            }
        } else if (config.useReplicatedServers() != null && "".equals(config.useReplicatedServers().getPassword())) {
            config.useReplicatedServers().setPassword(null);
        }
        if (this.redissonProperties.getConfig() == null && this.redissonProperties.getFile() == null) {
            config.setNettyThreads(DWRedissonConstants.nettyThreads);
            config.setThreads(DWRedissonConstants.threads);
            if (config.isClusterConfig()) {
                ((ClusterServersConfig)((ClusterServersConfig)((ClusterServersConfig)((ClusterServersConfig)((ClusterServersConfig)config.useClusterServers().setMasterConnectionMinimumIdleSize(DWRedissonConstants.masterConnectionMinimumIdleSize)).setMasterConnectionPoolSize(DWRedissonConstants.masterConnectionPoolSize)).setSlaveConnectionMinimumIdleSize(DWRedissonConstants.slaveConnectionMinimumIdleSize)).setSlaveConnectionPoolSize(DWRedissonConstants.slaveConnectionPoolSize)).setSubscriptionConnectionMinimumIdleSize(DWRedissonConstants.subscriptionConnectionMinimumIdleSize)).setSubscriptionConnectionPoolSize(DWRedissonConstants.subscriptionConnectionPoolSize);
            } else if (config.useSingleServer() != null) {
                config.useSingleServer().setConnectionMinimumIdleSize(DWRedissonConstants.masterConnectionMinimumIdleSize).setConnectionPoolSize(DWRedissonConstants.masterConnectionPoolSize);
            }
        }
    }

    public void setRedissonProperties(RedissonProperties redissonProperties) {
        this.redissonProperties = redissonProperties;
    }
}

