/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.redisson.service.impl;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.redisson.exception.DWUnlockException;
import com.digiwin.app.redisson.service.DWRedissonLock;
import java.util.concurrent.TimeUnit;
import org.redisson.Redisson;
import org.redisson.RedissonFairLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;

public class DWFairLockImpl
extends DWRedissonLock {
    private static final String LOCKTYPE = "fairLock";
    private static final Logger log = LoggerFactory.getLogger(DWFairLockImpl.class);

    public static String getLOCKTYPE() {
        return LOCKTYPE;
    }

    public DWFairLockImpl(String lockName, long leaseTime, long waitTime, TimeUnit unit, RedissonClient redissonClient, RedisTemplate redisTemplate) throws DWBusinessException {
        super(lockName, leaseTime, waitTime, unit);
        this.lock = new RedissonFairLock(((Redisson)redissonClient).getCommandExecutor(), lockName, 120000L);
        this.redisTemplate = redisTemplate;
    }

    public void lock() {
        throw new UnsupportedOperationException();
    }

    public void lock(long leaseTime, TimeUnit unit) {
        throw new UnsupportedOperationException();
    }

    public boolean tryLock() throws InterruptedException {
        if (this.waitTime == -1L && this.leaseTime == -1L) {
            return this.lock.tryLock();
        }
        return this.tryLock(this.waitTime, this.leaseTime, this.unit);
    }

    public boolean tryLock(long waitTime, long leaseTime, TimeUnit unit) throws InterruptedException {
        return this.lock.tryLock(waitTime, leaseTime, unit);
    }

    public void unlock() throws DWUnlockException {
        if (!this.lock.isLocked() || !this.lock.isHeldByCurrentThread()) {
            throw new DWUnlockException("\u7576\u524d\u9396\u5df2\u88ab\u89e3\u9396");
        }
        this.lock.unlock();
    }

    public boolean isHeldByCurrentThread() {
        return this.lock.isHeldByCurrentThread();
    }

    public boolean isLocked() {
        return this.lock.isLocked();
    }
}

