/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.autoconfigure;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.lettuce.core.resource.ClientResources;
import io.lettuce.core.resource.DWDefaultClientResources;
import io.lettuce.core.resource.NettyCustomizer;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.handler.timeout.IdleStateHandler;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.core.env.Environment;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.GenericJackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

@DependsOn(value={"dw-spring-context-utils"})
@Configuration
public class DapRedisTemplateAutoConfiguration {
    @Bean
    public RedisTemplate<String, Object> redisTemplate(RedisConnectionFactory redisConnectionFactory, Environment environment) {
        GenericJackson2JsonRedisSerializer serializer;
        String serializeNullString = environment.getProperty("dap.redis.serialize-null", "true");
        boolean serializeNull = Boolean.parseBoolean(serializeNullString);
        if (serializeNull) {
            serializer = new GenericJackson2JsonRedisSerializer();
        } else {
            ObjectMapper om = new ObjectMapper();
            om.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            om.enableDefaultTyping(ObjectMapper.DefaultTyping.NON_FINAL, JsonTypeInfo.As.PROPERTY);
            serializer = new GenericJackson2JsonRedisSerializer(om);
        }
        RedisTemplate redis = new RedisTemplate();
        redis.setKeySerializer((RedisSerializer)new StringRedisSerializer());
        redis.setValueSerializer((RedisSerializer)serializer);
        redis.setHashKeySerializer((RedisSerializer)new StringRedisSerializer());
        redis.setHashValueSerializer((RedisSerializer)serializer);
        redis.setConnectionFactory(redisConnectionFactory);
        redis.afterPropertiesSet();
        return redis;
    }

    @Bean
    public ClientResources clientResources() {
        NettyCustomizer nettyCustomizer = new NettyCustomizer(this){

            public void afterChannelInitialized(Channel channel) {
                channel.pipeline().addLast(new ChannelHandler[]{new IdleStateHandler(30, 30, 30)});
                channel.pipeline().addLast(new ChannelHandler[]{new ChannelDuplexHandler(this){

                    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                        if (evt instanceof IdleStateEvent) {
                            ctx.disconnect();
                        }
                    }
                }});
            }

            public void afterBootstrapInitialized(Bootstrap bootstrap) {
            }
        };
        return DWDefaultClientResources.builder().nettyCustomizer(nettyCustomizer).build();
    }
}

