/*
 * Decompiled with CFR 0.152.
 */
package com.dap.component.rocketmq.autoconfigure;

import com.dap.component.rocketmq.DWRocketMQConstants;
import com.dap.component.rocketmq.DWRocketMQException;
import com.dap.component.rocketmq.api.config.DWRocketMQConfigProvider;
import com.dap.component.rocketmq.api.properties.DWRocketMQConsumerProperties;
import com.dap.component.rocketmq.api.properties.DWRocketMQProducerProperties;
import com.dap.component.rocketmq.api.properties.DWRocketMQProperties;
import com.dap.component.rocketmq.consumer.DWRocketMQConsumerBeanPostProcessor;
import com.dap.component.rocketmq.producer.DWRocketMQProducerBeanDefinitionRegistryPostProcessor;
import com.digiwin.app.module.spring.SpringContextUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnProperty(name={"rocketmq.enabled"}, havingValue="true", matchIfMissing=false)
@DependsOn(value={"dw-spring-context-utils"})
public class DWRocketMQAutoConfiguration {
    @Bean(value={"dw-rocketMQProducerProperties"})
    @ConditionalOnMissingBean(value={DWRocketMQProducerProperties.class})
    public DWRocketMQProducerProperties newDWRocketMQProducerProperties() {
        return this.populateProducerProperties();
    }

    @Bean(value={"dw-rocketMQConsumerProperties"})
    @ConditionalOnMissingBean(value={DWRocketMQConsumerProperties.class})
    public DWRocketMQConsumerProperties newDWRocketMQConsumerProperties() {
        return this.populateConsumerProperties();
    }

    @Bean(value={"dw-rocketMQProducerBeanDefinitionRegistryPostProcessor"})
    @ConditionalOnClass(name={"com.digiwin.app.event.simplified.DWSimplifiedApolloApplicationListener"})
    @DependsOn(value={"dw-rocketMQProducerProperties"})
    @ConditionalOnMissingBean(value={DWRocketMQProducerBeanDefinitionRegistryPostProcessor.class})
    public DWRocketMQProducerBeanDefinitionRegistryPostProcessor newDWRocketMQProducerBeanDefinitionRegistryPostProcessor(DWRocketMQProducerProperties producerProperties) {
        DWRocketMQProducerBeanDefinitionRegistryPostProcessor definitionRegistryPostProcessor = new DWRocketMQProducerBeanDefinitionRegistryPostProcessor();
        definitionRegistryPostProcessor.setScanBasePackage(producerProperties.getScanBasePackage());
        return definitionRegistryPostProcessor;
    }

    @Bean(value={"dw-rocketMQConsumerBeanPostProcessor"})
    @ConditionalOnClass(name={"com.digiwin.app.event.simplified.DWSimplifiedApolloApplicationListener"})
    @DependsOn(value={"dw-rocketMQConsumerProperties"})
    @ConditionalOnMissingBean(value={DWRocketMQConsumerBeanPostProcessor.class})
    public DWRocketMQConsumerBeanPostProcessor newDWRocketMQConsumerBeanPostProcessor() {
        return new DWRocketMQConsumerBeanPostProcessor();
    }

    private DWRocketMQProducerProperties populateProducerProperties() {
        DWRocketMQProducerProperties properties = new DWRocketMQProducerProperties();
        DWRocketMQConfigProvider rocketMQConfigProvider = this.getDWRocketMQConfigProvider();
        this.populateBaseProperties((DWRocketMQProperties)properties, rocketMQConfigProvider);
        String scanBasePackage = rocketMQConfigProvider.getApplicationProperty("rocketmq.producer.scanBasePackage");
        if (StringUtils.hasText((String)scanBasePackage)) {
            properties.setScanBasePackage(scanBasePackage);
        } else {
            properties.setScanBasePackage("com.digiwin");
        }
        String sendMsgTimeout = rocketMQConfigProvider.getApplicationProperty("rocketmq.producer.sendMsgTimeout");
        if (StringUtils.hasText((String)sendMsgTimeout)) {
            properties.setSendMsgTimeout(Integer.valueOf(Integer.parseInt(sendMsgTimeout)));
        } else {
            properties.setSendMsgTimeout(DWRocketMQConstants.SEND_MSG_TIMEOUT);
        }
        String retrySendTimes = rocketMQConfigProvider.getApplicationProperty("rocketmq.producer.retrySendTimes");
        if (StringUtils.hasText((String)retrySendTimes)) {
            properties.setRetrySendTimes(Integer.valueOf(Integer.parseInt(retrySendTimes)));
        } else {
            properties.setRetrySendTimes(DWRocketMQConstants.RETRY_SEND_TIMES);
        }
        String maxMessageSize = rocketMQConfigProvider.getApplicationProperty("rocketmq.producer.maxMessageSize");
        if (StringUtils.hasText((String)maxMessageSize)) {
            properties.setMaxMessageSize(Integer.valueOf(Integer.parseInt(maxMessageSize)));
        } else {
            properties.setMaxMessageSize(DWRocketMQConstants.MAX_MESSAGE_SIZE);
        }
        String checkTransactionInterval = rocketMQConfigProvider.getApplicationProperty("rocketmq.producer.checkTransactionInterval");
        if (StringUtils.hasText((String)checkTransactionInterval)) {
            properties.setCheckTransactionInterval(Integer.valueOf(Integer.parseInt(checkTransactionInterval)));
        } else {
            properties.setCheckTransactionInterval(DWRocketMQConstants.CHECK_TX_INTERVAL);
        }
        return properties;
    }

    private DWRocketMQConsumerProperties populateConsumerProperties() {
        DWRocketMQConsumerProperties properties = new DWRocketMQConsumerProperties();
        DWRocketMQConfigProvider rocketMQConfigProvider = this.getDWRocketMQConfigProvider();
        this.populateBaseProperties((DWRocketMQProperties)properties, rocketMQConfigProvider);
        String retryConsumeTimes = rocketMQConfigProvider.getApplicationProperty("rocketmq.consumer.retryConsumeTimes");
        if (StringUtils.hasText((String)retryConsumeTimes)) {
            properties.setRetryConsumeTimes(Integer.valueOf(Integer.parseInt(retryConsumeTimes)));
        } else {
            properties.setRetryConsumeTimes(DWRocketMQConstants.RETRY_CONSUME_TIMES);
        }
        String consumeThreadNum = rocketMQConfigProvider.getApplicationProperty("rocketmq.consumer.consumeThreadNum");
        if (StringUtils.hasText((String)consumeThreadNum)) {
            properties.setConsumeThreadNum(Integer.valueOf(Integer.parseInt(consumeThreadNum)));
        } else {
            properties.setConsumeThreadNum(DWRocketMQConstants.CONSUME_THREAD_NUM);
        }
        String maxCacheMsgNum = rocketMQConfigProvider.getApplicationProperty("rocketmq.consumer.maxCacheMsgNum");
        if (StringUtils.hasText((String)maxCacheMsgNum)) {
            properties.setMaxCacheMsgNum(Integer.valueOf(Integer.parseInt(maxCacheMsgNum)));
        } else {
            properties.setMaxCacheMsgNum(DWRocketMQConstants.MAX_CACHE_MSG_NUM);
        }
        String maxCacheMsgSize = rocketMQConfigProvider.getApplicationProperty("rocketmq.consumer.maxCacheMsgSize");
        if (StringUtils.hasText((String)maxCacheMsgSize)) {
            properties.setMaxCacheMsgSize(Integer.valueOf(Integer.parseInt(maxCacheMsgSize)));
        } else {
            properties.setMaxCacheMsgSize(DWRocketMQConstants.MAX_CACHE_MSG_SIZE);
        }
        String consumeRequestTimeout = rocketMQConfigProvider.getApplicationProperty("rocketmq.consumer.consumeRequestTimeout");
        if (StringUtils.hasText((String)consumeRequestTimeout)) {
            properties.setConsumeRequestTimeout(Integer.valueOf(Integer.parseInt(consumeRequestTimeout)));
        } else {
            properties.setConsumeRequestTimeout(DWRocketMQConstants.CONSUME_REQUEST_TIMEOUT);
        }
        return properties;
    }

    private void populateBaseProperties(DWRocketMQProperties baseProperties, DWRocketMQConfigProvider rocketMQConfigProvider) {
        String sslEnabled;
        String secretKey;
        String endpoints = rocketMQConfigProvider.getApplicationProperty("rocketmq.endpoints");
        if (!StringUtils.hasText((String)endpoints)) {
            throw new DWRocketMQException("DWRocketMQ endpoint is required");
        }
        baseProperties.setEndpoints(endpoints);
        String accessKey = rocketMQConfigProvider.getApplicationProperty("rocketmq.accessKey");
        if (StringUtils.hasText((String)accessKey)) {
            baseProperties.setAccessKey(accessKey);
        }
        if (StringUtils.hasText((String)(secretKey = rocketMQConfigProvider.getApplicationProperty("rocketmq.secretKey")))) {
            baseProperties.setSecretKey(secretKey);
        }
        if (StringUtils.hasText((String)(sslEnabled = rocketMQConfigProvider.getApplicationProperty("rocketmq.sslEnabled")))) {
            baseProperties.setSslEnabled(Boolean.valueOf(Boolean.parseBoolean(sslEnabled)));
        }
    }

    private DWRocketMQConfigProvider getDWRocketMQConfigProvider() {
        return (DWRocketMQConfigProvider)SpringContextUtils.getBean((String)"dwRocketMQConfigProvider");
    }
}

