/*
 * Decompiled with CFR 0.152.
 */
package com.dap.component.rocketmq.consumer;

import com.dap.component.rocketmq.api.consumer.DWRocketMQConsumerInterceptor;
import com.dap.component.rocketmq.api.consumer.DWRocketMQConsumerMessageListener;
import com.digiwin.app.json.gson.DWGsonProvider;
import com.google.gson.Gson;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.rocketmq.client.apis.consumer.ConsumeResult;
import org.apache.rocketmq.client.apis.message.MessageView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.util.CollectionUtils;

public class DWRocketMQConsumerDefaultMessageListener
implements DWRocketMQConsumerMessageListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(DWRocketMQConsumerDefaultMessageListener.class);
    private Object beanObj;
    private Class<?> messageClazz;
    private Method invocableMethod;
    private List<DWRocketMQConsumerInterceptor> interceptors;
    private String topicName;
    private Gson gson;

    public DWRocketMQConsumerDefaultMessageListener(Object bean, Class<?> messageClazz, Method invocableMethod, List<DWRocketMQConsumerInterceptor> interceptors, String topicName) {
        this.beanObj = bean;
        this.messageClazz = messageClazz;
        this.invocableMethod = invocableMethod;
        this.interceptors = interceptors;
        this.topicName = topicName;
        this.gson = DWGsonProvider.getGson();
        this.interceptors.sort(Comparator.comparingInt(DWRocketMQConsumerInterceptor::getOrder));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ConsumeResult consume(MessageView messageView) {
        if (ObjectUtils.allNotNull((Object[])new Object[]{messageView, messageView.getBody()})) {
            Exception ex = null;
            try {
                messageView = this.invokeBefore(messageView);
                Object msgObj = this.convertMessage(messageView, this.messageClazz);
                StopWatch stopWatch = StopWatch.createStarted();
                Object returnVal = this.doInvoke(this.invocableMethod, this.beanObj, msgObj);
                if (!stopWatch.isStopped()) {
                    stopWatch.stop();
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Consume message[msgId={}] cost: {}ms", (Object)messageView.getMessageId(), (Object)stopWatch.getTime());
                }
                if (Objects.isNull(returnVal)) return ConsumeResult.SUCCESS;
                if (returnVal instanceof ConsumeResult) {
                    ConsumeResult consumeResult = (ConsumeResult)returnVal;
                    return consumeResult;
                }
                if (!(returnVal instanceof Boolean)) return ConsumeResult.SUCCESS;
                ConsumeResult consumeResult = (Boolean)returnVal != false ? ConsumeResult.SUCCESS : ConsumeResult.FAILURE;
                return consumeResult;
            }
            catch (Exception e) {
                ex = e;
                LOGGER.error("Consume message of method[{}] failed, msg:{}, err:{}", new Object[]{this.invocableMethod.getName(), messageView, ExceptionUtils.getStackTrace((Throwable)e)});
                ConsumeResult consumeResult = ConsumeResult.FAILURE;
                return consumeResult;
            }
            finally {
                try {
                    this.invokeAfter(messageView, ex);
                }
                catch (Exception e) {
                    LOGGER.error("Execute consumer 'invokeAfter' err:{}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
                }
            }
        }
        LOGGER.warn("'messageView' does not contain any body when consuming msg : {}", (Object)messageView);
        return ConsumeResult.SUCCESS;
    }

    public Object convertMessage(MessageView messageView, Class<?> targetClazz) {
        if (Objects.equals(targetClazz, MessageView.class)) {
            return messageView;
        }
        String msgBody = StandardCharsets.UTF_8.decode(messageView.getBody()).toString();
        if (Objects.equals(targetClazz, String.class)) {
            return msgBody;
        }
        return this.gson.fromJson(msgBody, targetClazz);
    }

    private Object doInvoke(Method invocableMethod, Object beanObj, Object paramObj) throws InvocationTargetException, IllegalAccessException {
        Method invokeMethod = BridgeMethodResolver.findBridgedMethod((Method)invocableMethod);
        return invokeMethod.invoke(beanObj, paramObj);
    }

    private MessageView invokeBefore(MessageView messageView) {
        if (!CollectionUtils.isEmpty(this.interceptors)) {
            for (DWRocketMQConsumerInterceptor interceptor : this.interceptors) {
                if (!CollectionUtils.isEmpty((Collection)interceptor.matchTopics()) && !interceptor.matchTopics().contains(this.topicName)) continue;
                messageView = interceptor.before(messageView);
            }
        }
        return messageView;
    }

    private void invokeAfter(MessageView messageView, Exception ex) {
        if (!CollectionUtils.isEmpty(this.interceptors)) {
            for (DWRocketMQConsumerInterceptor interceptor : this.interceptors) {
                if (!CollectionUtils.isEmpty((Collection)interceptor.matchTopics()) && !interceptor.matchTopics().contains(this.topicName)) continue;
                interceptor.after(messageView, ex);
            }
        }
    }
}

