/*
 * Decompiled with CFR 0.152.
 */
package com.dap.component.rocketmq.producer;

import com.google.common.base.MoreObjects;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.rocketmq.client.apis.message.Message;

public class DWRocketMQProducerMessage
implements Message {
    protected final Collection<String> keys;
    final byte[] body;
    private final String topic;
    @Nullable
    private final String tag;
    @Nullable
    private final String messageGroup;
    @Nullable
    private final Long deliveryTimestamp;
    private final Map<String, String> properties;

    public DWRocketMQProducerMessage(String topic, byte[] body, @Nullable String tag, Collection<String> keys, @Nullable String messageGroup, @Nullable Long deliveryTimestamp, Map<String, String> properties) {
        this.topic = topic;
        this.body = body;
        this.tag = tag;
        this.messageGroup = messageGroup;
        this.deliveryTimestamp = deliveryTimestamp;
        this.keys = keys;
        this.properties = properties;
    }

    public String getTopic() {
        return this.topic;
    }

    public ByteBuffer getBody() {
        return ByteBuffer.wrap(this.body);
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public Collection<String> getKeys() {
        return new ArrayList<String>(this.keys);
    }

    public Optional<String> getTag() {
        return Optional.ofNullable(this.tag);
    }

    public Optional<Long> getDeliveryTimestamp() {
        return Optional.ofNullable(this.deliveryTimestamp);
    }

    public Optional<String> getMessageGroup() {
        return Optional.ofNullable(this.messageGroup);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("topic", (Object)this.topic).add("tag", (Object)this.tag).add("messageGroup", (Object)this.messageGroup).add("deliveryTimestamp", (Object)this.deliveryTimestamp).add("keys", this.keys).add("properties", this.properties).toString();
    }
}

