/*
 * Decompiled with CFR 0.152.
 */
package com.dap.component.rocketmq.producer;

import com.dap.component.rocketmq.DWRocketMQException;
import com.dap.component.rocketmq.api.producer.DWRocketMQProducerCallback;
import com.dap.component.rocketmq.api.producer.DWRocketMQProducerResponse;
import com.digiwin.app.json.gson.DWGsonProvider;
import com.google.gson.Gson;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.rocketmq.client.apis.message.MessageView;
import org.apache.rocketmq.client.apis.producer.TransactionChecker;
import org.apache.rocketmq.client.apis.producer.TransactionResolution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public abstract class DWRocketMQProducerTransactionChecker<T>
implements TransactionChecker {
    private static final Logger LOGGER = LoggerFactory.getLogger(DWRocketMQProducerTransactionChecker.class);
    private Class<T> messageClazz;
    private Gson gson = DWGsonProvider.getGson();
    private DWRocketMQProducerCallback responseCallback;

    public void setMessageClazz(Class<T> messageClazz) {
        this.messageClazz = messageClazz;
    }

    public void setResponseCallback(DWRocketMQProducerCallback responseCallback) {
        this.responseCallback = responseCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionResolution check(MessageView messageView) {
        TransactionResolution resolution = TransactionResolution.UNKNOWN;
        Exception exception = null;
        if (ObjectUtils.allNotNull((Object[])new Object[]{messageView, messageView.getBody()})) {
            try {
                T message = this.parseMessage(messageView);
                Boolean result = this.doCheckTransaction(message);
                if (Objects.nonNull(result)) {
                    resolution = result != false ? TransactionResolution.COMMIT : TransactionResolution.ROLLBACK;
                }
            }
            catch (Exception e) {
                exception = e;
                LOGGER.error("Check local transaction status failed:{}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
            }
            finally {
                if (!Objects.equals(resolution, TransactionResolution.UNKNOWN)) {
                    try {
                        DWRocketMQProducerResponse response = this.populateProducerResponse(Objects.equals(resolution, TransactionResolution.COMMIT), messageView);
                        this.doResponseCallback(response, exception);
                    }
                    catch (Exception e) {
                        LOGGER.error("Execute 'doResponseCallback' failed:{}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
                    }
                }
            }
        }
        if (Objects.equals(resolution, TransactionResolution.UNKNOWN)) {
            LOGGER.warn("Current transaction resolution is unknown, msgView:{}", (Object)messageView);
        }
        return resolution;
    }

    protected abstract Boolean doCheckTransaction(T var1);

    protected Class<T> getMessageClazz() {
        if (Objects.isNull(this.messageClazz)) {
            Type superClass = this.getClass().getGenericSuperclass();
            ParameterizedType type = (ParameterizedType)superClass;
            this.messageClazz = (Class)type.getActualTypeArguments()[0];
        }
        return this.messageClazz;
    }

    private DWRocketMQProducerResponse populateProducerResponse(boolean success, MessageView messageView) {
        DWRocketMQProducerResponse response = new DWRocketMQProducerResponse(Boolean.valueOf(success));
        if (Objects.nonNull(messageView)) {
            if (Objects.nonNull(messageView.getMessageId())) {
                response.setMessageId(messageView.getMessageId().toString());
            }
            response.setExtInfo(this.extractMsgExt(messageView));
        }
        return response;
    }

    private void doResponseCallback(DWRocketMQProducerResponse response, Exception exception) {
        if (Objects.nonNull(this.responseCallback)) {
            if (!response.getSuccess().booleanValue()) {
                if (Objects.isNull(exception)) {
                    exception = new DWRocketMQException("The result of the check local transaction is not committed.");
                }
                this.responseCallback.onFailure(response, (Throwable)exception);
            } else {
                this.responseCallback.onSuccess(response);
            }
        }
    }

    private T parseMessage(MessageView messageView) {
        if (MessageView.class.equals(this.getMessageClazz())) {
            return (T)messageView;
        }
        String msgBody = StandardCharsets.UTF_8.decode(messageView.getBody()).toString();
        if (String.class.equals(this.getMessageClazz())) {
            return (T)msgBody;
        }
        return (T)this.gson.fromJson(msgBody, this.getMessageClazz());
    }

    private String extractMsgExt(MessageView message) {
        if (Objects.nonNull(message)) {
            String result;
            StringBuilder sb = new StringBuilder("msgExt{");
            if (StringUtils.hasText((String)message.getTopic())) {
                sb.append("topic=").append(message.getTopic()).append(",");
            }
            if (message.getTag().isPresent()) {
                sb.append("tag=").append((String)message.getTag().get()).append(",");
            }
            if (!CollectionUtils.isEmpty((Collection)message.getKeys())) {
                sb.append("keys=").append(message.getKeys()).append(",");
            }
            if (message.getMessageGroup().isPresent()) {
                sb.append("messageGroup=").append((String)message.getMessageGroup().get()).append(",");
            }
            if (message.getDeliveryTimestamp().isPresent()) {
                sb.append("deliveryTimestamp=").append(message.getDeliveryTimestamp().get()).append(",");
            }
            if ((result = sb.toString()).lastIndexOf(",") != -1) {
                result = result.substring(0, result.lastIndexOf(","));
            }
            return result + "}";
        }
        return null;
    }
}

