/*
 * Decompiled with CFR 0.152.
 */
package com.dap.component.rocketmq.producer.handler;

import com.dap.component.rocketmq.DWRocketMQException;
import com.dap.component.rocketmq.api.producer.DWRocketMQProducerParam;
import com.dap.component.rocketmq.producer.DWRocketMQProducerMessage;
import com.dap.component.rocketmq.producer.handler.DWRocketMQProducerBaseHandler;
import com.dap.component.rocketmq.producer.params.DWRocketMQProducerDelayParam;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import org.apache.rocketmq.client.apis.message.Message;

public class DWRocketMQProducerDelayHandler
extends DWRocketMQProducerBaseHandler {
    @Override
    public <T> void sendMessage(String topic, String tag, Boolean enableAsync, DWRocketMQProducerParam<T> requestParam) {
        super.sendMessage(topic, tag, enableAsync, requestParam);
    }

    @Override
    protected <T> Message buildDWRocketMessage(String topic, String tag, DWRocketMQProducerParam<T> requestParam) {
        if (!DWRocketMQProducerDelayParam.class.isAssignableFrom(requestParam.getClass())) {
            throw new DWRocketMQException("'requestParam' must be instance of DWRocketMQProducerDelayParam.");
        }
        DWRocketMQProducerDelayParam delayParam = (DWRocketMQProducerDelayParam)requestParam;
        if (delayParam.getDelaySecTime() <= 0) {
            throw new DWRocketMQException("'delaySecTime' must be greater than zero.");
        }
        return new DWRocketMQProducerMessage(topic, this.parseJson(requestParam.getMsgBody()), tag, List.of(requestParam.getBusinessId()), null, System.currentTimeMillis() + Duration.ofSeconds(delayParam.getDelaySecTime().intValue()).toMillis(), new HashMap<String, String>());
    }
}

